/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.engine.annotated.scanner;

import io.higson.runtime.engine.annotated.PackageList;
import io.higson.runtime.engine.annotated.RepositoryObjectKey;
import io.higson.runtime.engine.annotated.scanner.AnnotatedObjectsScanner;
import io.higson.runtime.engine.annotated.scanner.TypeScanner;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;

public class PackageTypeScanner
implements TypeScanner {
    private final PackageList packagesToScan;

    public PackageTypeScanner(PackageList packagesToScan) {
        this.packagesToScan = packagesToScan;
    }

    @Override
    public <T> Map<RepositoryObjectKey, T> scanTypes(Class<? extends Annotation> annotationType) {
        AnnotatedObjectsScanner scanner = new AnnotatedObjectsScanner();
        Map objects = scanner.getAnnotatedObjects(annotationType, this.createPackagesForDefaults(this.packagesToScan));
        Map userObjects = scanner.getAnnotatedObjects(annotationType, this.packagesToScan);
        objects.putAll(userObjects);
        return objects;
    }

    @Override
    public <T> List<T> scanTypesWithoutName(Class<? extends Annotation> annotationType) {
        AnnotatedObjectsScanner scanner = new AnnotatedObjectsScanner();
        return scanner.getAnnotatedObjectsWithoutName(annotationType, this.packagesToScan);
    }

    private PackageList createPackagesForDefaults(PackageList packagesToScan) {
        PackageList defaultPackages = new PackageList();
        defaultPackages.add(packagesToScan.getDefaultPackage());
        return defaultPackages;
    }
}

