/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.engine.config;

import io.higson.runtime.core.Properties;
import io.higson.runtime.engine.annotated.RepositoryObjectKey;
import io.higson.runtime.engine.annotated.repository.ScanningFunctionProvider;
import io.higson.runtime.engine.annotated.repository.ScanningInvokerRepository;
import io.higson.runtime.engine.annotated.repository.ScanningMatcherRepository;
import io.higson.runtime.engine.annotated.repository.ScanningTypeRepository;
import io.higson.runtime.engine.cache.MapFunctionCache;
import io.higson.runtime.engine.cache.MapPreparedParamCache;
import io.higson.runtime.engine.config.initialization.ComponentInitializer;
import io.higson.runtime.engine.config.initialization.ComponentInitializerRunner;
import io.higson.runtime.engine.config.pico.ComponentConfig;
import io.higson.runtime.engine.core.function.FunctionCache;
import io.higson.runtime.engine.core.function.FunctionInvoker;
import io.higson.runtime.engine.core.function.FunctionRepository;
import io.higson.runtime.engine.core.matcher.Matcher;
import io.higson.runtime.engine.core.parameter.BasicParameterProvider;
import io.higson.runtime.engine.core.parameter.ParamRepository;
import io.higson.runtime.engine.core.prepared.BasicLevelPreparer;
import io.higson.runtime.engine.core.prepared.BasicParamPreparer;
import io.higson.runtime.engine.core.prepared.PreparedParamCache;
import io.higson.runtime.engine.core.type.Type;
import io.higson.runtime.engine.core.type.ValueHolder;
import io.higson.runtime.function.FunctionInvocationInterceptor;
import io.higson.runtime.function.FunctionManager;
import io.higson.runtime.level.OutputLevelArraySeparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ParamEngineConfig
extends ComponentConfig {
    private final List<ParamRepository> parameterRepositories = new ArrayList<ParamRepository>();
    private final Map<RepositoryObjectKey, FunctionRepository> functionRepositories = new HashMap<RepositoryObjectKey, FunctionRepository>();
    private final Map<String, FunctionInvoker> functionInvokers = new HashMap<String, FunctionInvoker>();
    private final Map<String, Type<? extends ValueHolder>> types = new HashMap<String, Type<? extends ValueHolder>>();
    private final Map<String, Matcher> matchers = new HashMap<String, Matcher>();
    private final List<FunctionInvocationInterceptor> functionInvocationInterceptors = new ArrayList<FunctionInvocationInterceptor>();
    private PreparedParamCache parameterCache;
    private FunctionCache functionCache;
    private ComponentInitializerRunner initializationRunner;
    private Properties properties;
    private final List<ComponentInitializer> componentInitializers = new ArrayList<ComponentInitializer>();

    @Override
    protected void injectDefaults(List<Object> components) {
        components.add(BasicParamPreparer.class);
        components.add(BasicLevelPreparer.class);
        components.add(MapPreparedParamCache.class);
        components.add(FunctionManager.class);
        components.add(ScanningFunctionProvider.class);
        components.add(MapFunctionCache.class);
        components.add(ScanningInvokerRepository.class);
        components.add(BasicParameterProvider.class);
        components.add(ScanningTypeRepository.class);
        components.add(ScanningMatcherRepository.class);
    }

    public List<ParamRepository> getParameterRepositories() {
        return Collections.unmodifiableList(this.parameterRepositories);
    }

    protected void addParameterRepositories(List<ParamRepository> parameterRepositories) {
        this.parameterRepositories.addAll(parameterRepositories);
    }

    public Map<RepositoryObjectKey, FunctionRepository> getFunctionRepositories() {
        return Collections.unmodifiableMap(this.functionRepositories);
    }

    protected void addFunctionRepository(RepositoryObjectKey key, FunctionRepository functionRepository) {
        this.functionRepositories.put(key, functionRepository);
    }

    public Map<String, FunctionInvoker> getFunctionInvokers() {
        return Collections.unmodifiableMap(this.functionInvokers);
    }

    protected void addFunctionInvoker(String key, FunctionInvoker functionInvoker) {
        this.functionInvokers.put(key, functionInvoker);
    }

    public List<FunctionInvocationInterceptor> getFunctionInvocationInterceptors() {
        return Collections.unmodifiableList(this.functionInvocationInterceptors);
    }

    protected void addFunctionInvocationInterceptor(FunctionInvocationInterceptor functionInvocationInterceptor) {
        this.functionInvocationInterceptors.add(functionInvocationInterceptor);
    }

    protected void addFunctionInvocationInterceptors(List<FunctionInvocationInterceptor> functionInvocationInterceptors) {
        this.functionInvocationInterceptors.addAll(functionInvocationInterceptors);
    }

    protected void setProperties(Properties properties) {
        this.properties = properties;
    }

    public Map<String, Type<? extends ValueHolder>> getTypes() {
        return Collections.unmodifiableMap(this.types);
    }

    protected <T extends ValueHolder> void addType(String key, Type<T> type) {
        this.types.put(key, type);
    }

    public Map<String, Matcher> getMatchers() {
        return Collections.unmodifiableMap(this.matchers);
    }

    protected void addMatcher(String key, Matcher matcher) {
        this.matchers.put(key, matcher);
    }

    protected void setFunctionCache(FunctionCache functionCache) {
        this.functionCache = functionCache;
        this.addComponent(functionCache);
    }

    protected void setParameterCache(PreparedParamCache parameterCache) {
        this.parameterCache = parameterCache;
        this.addComponent(parameterCache);
    }

    public List<ComponentInitializer> getComponentInitializers() {
        return Collections.unmodifiableList(this.componentInitializers);
    }

    protected void addComponentInitializers(List<ComponentInitializer> componentInitializers) {
        this.componentInitializers.addAll(componentInitializers);
    }

    public void setOutputLevelArraySeparator(OutputLevelArraySeparator outputLevelArraySeparator) {
        this.addComponent((Object)outputLevelArraySeparator);
    }

    public PreparedParamCache getParameterCache() {
        return this.parameterCache;
    }

    public FunctionCache getFunctionCache() {
        return this.functionCache;
    }

    public ComponentInitializerRunner getInitializationRunner() {
        return this.initializationRunner;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setInitializationRunner(ComponentInitializerRunner initializationRunner) {
        this.initializationRunner = initializationRunner;
    }
}

