/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.engine.core;

import io.higson.runtime.core.Properties;
import io.higson.runtime.core.PropertiesAware;
import io.higson.runtime.engine.core.InvalidFunctionToCallException;
import io.higson.runtime.engine.core.InvalidLevelValuesQuery;
import io.higson.runtime.engine.core.ParamEngine;
import io.higson.runtime.engine.core.ParamEngineRuntimeConfig;
import io.higson.runtime.engine.core.ParamEngineRuntimeConfigBuilder;
import io.higson.runtime.engine.core.ParameterValueNotFoundException;
import io.higson.runtime.engine.core.UndefinedLevelCreatorException;
import io.higson.runtime.engine.core.UnknownParameterException;
import io.higson.runtime.engine.core.context.LevelValues;
import io.higson.runtime.engine.core.context.ParamContext;
import io.higson.runtime.engine.core.decoder.ValueDecoder;
import io.higson.runtime.engine.core.function.Function;
import io.higson.runtime.engine.core.function.FunctionManager;
import io.higson.runtime.engine.core.index.LevelIndex;
import io.higson.runtime.engine.core.output.MultiValue;
import io.higson.runtime.engine.core.output.ParamValue;
import io.higson.runtime.engine.core.output.ParamValueImpl;
import io.higson.runtime.engine.core.prepared.InputValueNormalizer;
import io.higson.runtime.engine.core.prepared.ParamPreparer;
import io.higson.runtime.engine.core.prepared.PreparedEntry;
import io.higson.runtime.engine.core.prepared.PreparedLevel;
import io.higson.runtime.engine.core.prepared.PreparedParameter;
import io.higson.runtime.engine.core.type.Type;
import io.higson.runtime.engine.core.type.ValueHolder;
import io.higson.runtime.engine.ext.FunctionInvokerInterceptor;
import io.higson.runtime.engine.types.string.StringHolder;
import io.higson.runtime.exception.HigsonRuntimeException;
import io.higson.runtime.level.LevelArraySplitter;
import io.higson.runtime.level.OutputLevelArraySeparator;
import io.higson.runtime.model.Parameter;
import io.higson.runtime.utils.hash.HashUtils;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartParamEngine
implements ParamEngine,
PropertiesAware {
    private static final Logger log = LoggerFactory.getLogger(SmartParamEngine.class);
    private static final PreparedEntry[] EMPTY_ENTRY_ARRAY = new PreparedEntry[0];
    private final ParamEngineRuntimeConfigBuilder configBuilder;
    private final ParamPreparer paramPreparer;
    private final FunctionManager functionManager;
    private final OutputLevelArraySeparator outputLevelArraySeparator;
    private FunctionInvokerInterceptor invokerInterceptor;
    private Properties properties;

    public SmartParamEngine(ParamPreparer paramPreparer, FunctionManager functionManager, ParamEngineRuntimeConfigBuilder configBuilder, OutputLevelArraySeparator arraySeparator) {
        this.paramPreparer = paramPreparer;
        this.functionManager = functionManager;
        this.configBuilder = configBuilder;
        this.outputLevelArraySeparator = arraySeparator;
    }

    public void setInvokerInterceptor(FunctionInvokerInterceptor invokerInterceptor) {
        this.invokerInterceptor = invokerInterceptor;
        log.debug("enabling function invoker interceptor: {}", (Object)invokerInterceptor);
    }

    @Override
    public ParamEngineRuntimeConfig runtimeConfiguration() {
        return this.configBuilder.buildConfig();
    }

    @Override
    public String getDigest(io.higson.runtime.model.Type type, String elementCode) {
        switch (type) {
            case LITERAL: {
                return HashUtils.sha1(new String[]{elementCode});
            }
            case PARAMETER: {
                return this.getParameterDigest(elementCode);
            }
            case FUNCTION: {
                return this.getFunctionDigest(elementCode);
            }
        }
        throw new HigsonRuntimeException("unsupported type: " + type);
    }

    private String getFunctionDigest(String elementCode) {
        return this.functionManager.get(elementCode).getDigest();
    }

    private String getParameterDigest(String elementCode) {
        PreparedParameter param = this.getPreparedParameter(elementCode);
        return ((Parameter)param.getMetadata()).getDigest();
    }

    @Override
    public ParamValue get(String paramName, ParamContext ctx) {
        log.debug("enter get[{}], ctx={}", (Object)paramName, (Object)ctx);
        PreparedParameter param = this.getPreparedParameter(paramName);
        PreparedEntry[] rows = this.findParameterEntries(param, ctx);
        if (rows.length == 0) {
            return this.returnEmptyEntriesResult(paramName, ctx, param);
        }
        return this.parseFoundEntries(paramName, ctx, param, rows);
    }

    private ParamValue parseFoundEntries(String paramName, ParamContext ctx, PreparedParameter param, PreparedEntry[] entries) {
        int inputLevelCount = param.getInputLevelsCount();
        int outputLevelCount = param.getLevelCount() - inputLevelCount;
        LevelArraySplitter arraySplitter = new LevelArraySplitter();
        MultiValue[] parsedEntries = (MultiValue[])Arrays.stream(entries).map(entry -> {
            PreparedLevel[] levels = param.getLevels();
            Object[] vector = new Object[outputLevelCount];
            for (int columnIndex = 0; columnIndex < outputLevelCount; ++columnIndex) {
                String cellText = entry.getLevel(inputLevelCount + columnIndex + 1);
                PreparedLevel level = levels[inputLevelCount + columnIndex];
                Type<? extends ValueHolder> cellType = level.getType();
                ValueDecoder decoder = level.getDecoder();
                ValueHolder[] cellValue = level.isArray() ? this.decodeFromArray(arraySplitter, ctx, cellText, cellType, decoder) : decoder.decode(cellText, cellType, ctx);
                vector[columnIndex] = cellValue;
            }
            return new MultiValue(vector, param.getLevelNameMap(), paramName);
        }).toArray(MultiValue[]::new);
        ParamValueImpl result = new ParamValueImpl(parsedEntries, param.getMetadata());
        log.debug("leave get[{}], result={}", (Object)paramName, (Object)result);
        return result;
    }

    private ParamValue returnEmptyEntriesResult(String paramName, ParamContext ctx, PreparedParameter param) {
        if (param.isNullable()) {
            log.debug("leave get[{}], result=null", (Object)paramName);
            return null;
        }
        throw new ParameterValueNotFoundException(paramName, ctx);
    }

    private ValueHolder[] decodeFromArray(LevelArraySplitter arraySplitter, ParamContext ctx, String cellText, Type<?> cellType, ValueDecoder decoder) {
        LevelArraySplitter.SplitConfiguration splitConfiguration = new LevelArraySplitter.SplitConfiguration(cellType, this.outputLevelArraySeparator);
        LevelArraySplitter.DecoderConfiguration decoderConfiguration = new LevelArraySplitter.DecoderConfiguration(decoder, ctx);
        return arraySplitter.split(cellText, splitConfiguration, decoderConfiguration);
    }

    @Override
    public ParamValue get(String paramName, Object ... inputLevels) {
        LevelValues ctx = new LevelValues(inputLevels);
        return this.get(paramName, ctx);
    }

    @Override
    public Object callFunction(String functionName, Object ... args) {
        if (log.isDebugEnabled()) {
            log.debug("calling function [{}] with args: {}", (Object)functionName, (Object)this.classNames(args));
        }
        Object result = this.functionManager.invokeFunction(functionName, args);
        log.debug("function result: {}", result);
        return result;
    }

    private String[] classNames(Object ... args) {
        String[] names = new String[args.length];
        for (int i = 0; i < args.length; ++i) {
            names[i] = args[i] != null ? args[i].getClass().getSimpleName() : "null";
        }
        return names;
    }

    @Override
    public Object callEvaluatedFunction(String paramName, ParamContext ctx, Object ... args) {
        ValueHolder holder = this.get(paramName, ctx).getHolder();
        if (!(holder instanceof StringHolder)) {
            throw new InvalidFunctionToCallException(paramName, holder);
        }
        String functionName = holder.getString();
        if (functionName != null) {
            return this.callFunction(functionName, args);
        }
        return null;
    }

    private void evaluateLevelValues(PreparedParameter param, ParamContext ctx) {
        PreparedLevel[] levels = param.getLevels();
        Object[] values = new Object[param.getInputLevelsCount()];
        for (int levelIndex = 0; levelIndex < values.length; ++levelIndex) {
            PreparedLevel level = levels[levelIndex];
            Function levelCreator = level.getLevelCreator();
            if (levelCreator == null) {
                throw new UndefinedLevelCreatorException(levelIndex);
            }
            String levelCreatorName = levelCreator.getName();
            log.trace("L{}: using level creator: {}", (Object)levelIndex, (Object)levelCreatorName);
            Object result = this.invokerInterceptor != null ? this.invokerInterceptor.invokeFunction(levelCreatorName, ctx, new Object[0]) : this.functionManager.invokeFunction(levelCreatorName, ctx);
            values[levelIndex] = result;
        }
        if (log.isDebugEnabled()) {
            log.debug("discovered level values: {}", (Object)Arrays.toString(values));
        }
        ctx.setLevelValues(values);
    }

    private PreparedEntry[] findParameterEntries(PreparedParameter param, String[][] levelValues) {
        List<PreparedEntry> entries;
        if (param.isCacheable()) {
            LevelIndex<PreparedEntry> index = param.getIndex();
            entries = index.find(levelValues);
        } else {
            entries = this.paramPreparer.findEntries(param.getId(), levelValues);
        }
        return entries != null ? entries.toArray(new PreparedEntry[0]) : EMPTY_ENTRY_ARRAY;
    }

    private void validateLevelValues(Object[][] levelValues, int parameterLevelCount) {
        if (levelValues.length != parameterLevelCount) {
            throw new InvalidLevelValuesQuery((Object[])levelValues, parameterLevelCount);
        }
    }

    private PreparedEntry[] findParameterEntries(PreparedParameter param, ParamContext ctx) {
        if (ctx.getLevelValues() == null) {
            this.evaluateLevelValues(param, ctx);
        }
        this.validateLevelValues(ctx.getLevelValues(), param.getInputLevelsCount());
        String[][] normalizedInputValues = InputValueNormalizer.normalize(param, ctx.getLevelValues(), this.properties.isThrowOnNormalizeInputValueException());
        return this.findParameterEntries(param, normalizedInputValues);
    }

    private PreparedParameter getPreparedParameter(String paramName) {
        PreparedParameter param = this.paramPreparer.getPreparedParameter(paramName);
        if (param == null) {
            throw new UnknownParameterException(paramName);
        }
        return param;
    }

    @Override
    public void setProperties(Properties properties) {
        this.properties = properties;
    }
}

