/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.engine.core.type;

import io.higson.runtime.engine.core.type.Type;
import io.higson.runtime.engine.core.type.ValueHolder;
import io.higson.runtime.engine.util.EngineUtil;

public abstract class AbstractType<V, H extends ValueHolder>
implements Type<H> {
    private final Class<V> heldClass;

    protected AbstractType(Class<V> heldClass) {
        this.heldClass = heldClass;
    }

    protected abstract H createEmptyHolder();

    protected abstract H createHolder(V var1);

    @Override
    public H decode(String text) {
        return EngineUtil.hasText(text) ? this.decodeHolder(text) : this.createEmptyHolder();
    }

    @Override
    public String encode(H holder) {
        return holder.getString();
    }

    protected abstract H decodeHolder(String var1);

    @Override
    public H convert(Object obj) {
        if (obj == null) {
            return this.createEmptyHolder();
        }
        if (this.heldClass.isAssignableFrom(obj.getClass())) {
            return this.createHolder(obj);
        }
        if (obj instanceof String) {
            return this.decode((String)obj);
        }
        throw new IllegalArgumentException("Conversion not supported for: " + obj.getClass());
    }
}

