/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.engine.types.date;

import io.higson.runtime.engine.annotated.annotations.ParamType;
import io.higson.runtime.engine.core.type.Type;
import io.higson.runtime.engine.types.date.AbstractDateType;
import io.higson.runtime.engine.types.date.DateTimeFormatterPool;
import io.higson.runtime.engine.types.date.LocalDateHolder;
import io.higson.runtime.engine.types.date.LocalDateParserChain;
import io.higson.runtime.engine.util.EngineUtil;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeParseException;
import java.util.Calendar;
import java.util.Date;

@ParamType(value="localDate")
public class LocalDateType
extends AbstractDateType<LocalDate>
implements Type<LocalDateHolder> {
    private final LocalDateParserChain parserChain = LocalDateParserChain.build();

    @Override
    public String encode(LocalDateHolder holder) {
        return holder.getString();
    }

    @Override
    public LocalDateHolder decode(String text) {
        LocalDate localDate = EngineUtil.hasText(text) ? (LocalDate)this.guess(text) : null;
        return new LocalDateHolder(localDate);
    }

    @Override
    public LocalDateHolder convert(Object obj) {
        if (obj instanceof LocalDate) {
            return new LocalDateHolder((LocalDate)obj);
        }
        if (obj instanceof LocalDateTime) {
            return new LocalDateHolder(((LocalDateTime)obj).toLocalDate());
        }
        if (obj instanceof Date) {
            return new LocalDateHolder(this.convertDateToLocalDate((Date)obj));
        }
        if (obj instanceof Calendar) {
            Calendar cal = (Calendar)obj;
            return new LocalDateHolder(this.convertDateToLocalDate(cal.getTime()));
        }
        if (obj == null) {
            return new LocalDateHolder(null);
        }
        if (obj instanceof String) {
            return this.decode((String)obj);
        }
        throw new IllegalArgumentException("conversion not supported for: " + obj.getClass());
    }

    private LocalDate convertDateToLocalDate(Date date) {
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public LocalDateHolder[] newArray(int size) {
        return new LocalDateHolder[size];
    }

    @Override
    protected LocalDate parse(String dateStr, String pattern) {
        try {
            return LocalDate.parse(dateStr, DateTimeFormatterPool.ofPattern(pattern));
        }
        catch (DateTimeParseException e) {
            return (LocalDate)this.parserChain.parse(dateStr);
        }
    }
}

