/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.engine.types.datetime;

import io.higson.runtime.engine.annotated.annotations.ParamType;
import io.higson.runtime.engine.core.type.Type;
import io.higson.runtime.engine.types.datetime.AbstractDateTimeType;
import io.higson.runtime.engine.types.datetime.LocalDateTimeHolder;
import io.higson.runtime.engine.types.datetime.LocalDateTimeParserChain;
import io.higson.runtime.engine.util.EngineUtil;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

@ParamType(value="localDateTime")
public class LocalDateTimeType
extends AbstractDateTimeType<LocalDateTime>
implements Type<LocalDateTimeHolder> {
    private final LocalDateTimeParserChain parserChain = LocalDateTimeParserChain.build();

    @Override
    public String encode(LocalDateTimeHolder holder) {
        return holder.getString();
    }

    @Override
    public LocalDateTimeHolder decode(String text) {
        LocalDateTime date = EngineUtil.hasText(text) ? this.tryDecode(text) : null;
        return new LocalDateTimeHolder(date);
    }

    private LocalDateTime tryDecode(String text) {
        try {
            return (LocalDateTime)this.guess(text);
        }
        catch (IllegalArgumentException e) {
            return (LocalDateTime)this.parserChain.parse(text);
        }
    }

    @Override
    public LocalDateTimeHolder convert(Object obj) {
        if (obj instanceof LocalDateTime) {
            return new LocalDateTimeHolder((LocalDateTime)obj);
        }
        if (obj instanceof LocalDate) {
            return new LocalDateTimeHolder(((LocalDate)obj).atStartOfDay());
        }
        if (obj instanceof Date) {
            return new LocalDateTimeHolder(this.convertDateToLocalDateTime((Date)obj));
        }
        if (obj instanceof Calendar) {
            Calendar cal = (Calendar)obj;
            return new LocalDateTimeHolder(this.convertDateToLocalDateTime(cal.getTime()));
        }
        if (obj == null) {
            return new LocalDateTimeHolder(null);
        }
        if (obj instanceof String) {
            return this.decode((String)obj);
        }
        throw new IllegalArgumentException("conversion not supported for: " + obj.getClass());
    }

    private LocalDateTime convertDateToLocalDateTime(Date date) {
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    public LocalDateTimeHolder[] newArray(int size) {
        return new LocalDateTimeHolder[size];
    }

    @Override
    protected LocalDateTime parseLong(String input) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(Long.parseLong(input)), TimeZone.getDefault().toZoneId());
    }

    @Override
    protected LocalDateTime of(long date) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(date), TimeZone.getDefault().toZoneId());
    }
}

