/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.engine.util;

import io.higson.runtime.engine.core.output.MultiValue;
import io.higson.runtime.exception.HigsonRuntimeException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiValueUtil {
    private static final Logger log = LoggerFactory.getLogger(MultiValueUtil.class);
    private static final Comparator<Map.Entry<String, Integer>> mapEntryCompareByValue = Comparator.comparing(Map.Entry::getValue);

    private MultiValueUtil() {
        throw new UnsupportedOperationException();
    }

    public static List<String> getKeys(MultiValue multiValue) {
        if (multiValue == null) {
            return Collections.emptyList();
        }
        try {
            Map<String, Integer> indexMap = MultiValueUtil.getIndexMap(multiValue);
            ArrayList<Map.Entry<String, Integer>> indexMapping = new ArrayList<Map.Entry<String, Integer>>(indexMap.entrySet());
            return indexMapping.stream().sorted(mapEntryCompareByValue).map(Map.Entry::getKey).collect(Collectors.toList());
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
            throw new HigsonRuntimeException(e.getMessage(), e);
        }
    }

    private static Map<String, Integer> getIndexMap(MultiValue multiValue) throws IllegalAccessException {
        Map indexMap = (Map)FieldUtils.readField(multiValue, "indexMap", true);
        if (Objects.isNull(indexMap)) {
            return Collections.emptyMap();
        }
        return indexMap;
    }
}

