/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.ext.adapter;

import io.higson.runtime.core.HigsonSubContext;
import io.higson.runtime.exception.HigsonRuntimeException;
import io.higson.runtime.ext.adapter.Adapter;
import io.higson.runtime.ext.adapter.AdapterFactory;
import io.higson.runtime.ext.adapter.AdapterFactoryImpl;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public class CollectionAdapter<E>
implements Iterable<HigsonSubContext> {
    private final Collection<E> collection;
    private final AdapterFactory<E> factory;

    public CollectionAdapter(Collection<E> collection, AdapterFactory<E> factory) {
        this.collection = this.notnull(collection);
        this.factory = factory;
    }

    public <A extends Adapter> CollectionAdapter(Collection<E> collection, Class<A> adapterClass) {
        this.collection = this.notnull(collection);
        this.factory = new AdapterFactoryImpl(adapterClass);
    }

    public int size() {
        return this.collection.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    @Override
    public Iterator<HigsonSubContext> iterator() {
        return new Iterator<HigsonSubContext>(){
            private Iterator<E> it;
            {
                this.it = CollectionAdapter.this.collection.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public HigsonSubContext next() {
                Object e = this.it.next();
                return CollectionAdapter.this.factory.create(e);
            }

            @Override
            public void remove() {
                throw new HigsonRuntimeException("Illegal operation");
            }
        };
    }

    private Collection<E> notnull(Collection<E> coll) {
        return coll != null ? coll : Collections.emptyList();
    }
}

