/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.function.groovy.shell;

import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyCodeSource;
import groovy.lang.GroovyObjectSupport;
import groovy.lang.Script;
import io.higson.runtime.constants.FunctionCode;
import io.higson.runtime.function.groovy.shell.CompilationResultVerifier;
import io.higson.runtime.function.groovy.shell.CompiledGroovyFunction;
import io.higson.runtime.function.log.FunctionLoggerCreator;
import io.higson.runtime.function.log.ListenableLogger;
import io.higson.runtime.function.log.LogListener;
import io.higson.runtime.function.log.RuntimeLogger;
import io.higson.runtime.invoker.GroovyPreprocessor;
import io.higson.runtime.model.GroovyFunction;
import java.security.AccessController;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.MultipleCompilationErrorsException;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.ExceptionMessage;
import org.codehaus.groovy.control.messages.Message;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedGroovyShell
extends GroovyObjectSupport {
    private static final Logger log = LoggerFactory.getLogger(CachedGroovyShell.class);
    private static final String DEFAULT_CODE_BASE = "/groovy/shell";
    private final Map<Integer, CompiledGroovyFunction> compileCache = new ConcurrentHashMap<Integer, CompiledGroovyFunction>();
    private final Binding context;
    private final GroovyClassLoader loader;
    private final GroovyPreprocessor preprocessor;
    private final FunctionLoggerCreator functionLoggerCreator;
    private final CompilationResultVerifier resultVerifier;
    private final boolean groovySecured;

    public CachedGroovyShell(FunctionLoggerCreator functionLoggerCreator, boolean groovySecured) {
        this.functionLoggerCreator = functionLoggerCreator;
        this.groovySecured = groovySecured;
        this.preprocessor = new GroovyPreprocessor();
        this.context = new Binding();
        this.resultVerifier = new CompilationResultVerifier();
        ClassLoader parentLoader = CachedGroovyShell.class.getClassLoader();
        this.loader = AccessController.doPrivileged(() -> new GroovyClassLoader(parentLoader, CompilerConfiguration.DEFAULT));
    }

    public CachedGroovyShell(FunctionLoggerCreator functionLoggerCreator) {
        this(functionLoggerCreator, false);
    }

    public Object evaluate(GroovyFunction function, Binding args) {
        log.trace("Evaluating groovy script: {} with args: {}", (Object)function.getImplId(), (Object)args.getVariables());
        CompiledGroovyFunction compiledFunction = this.getCompiled(function);
        this.mergeWithContext(args, compiledFunction.getLogger());
        Script script = InvokerHelper.createScript(compiledFunction.getCompiled(), args);
        return script.run();
    }

    public List<? extends Message> validate(String scriptText) {
        log.debug("Validating groovy script");
        if (StringUtils.isEmpty(scriptText)) {
            log.warn("omitting empty script from validation");
            return Collections.emptyList();
        }
        return this.validateFunction(scriptText);
    }

    private List<? extends Message> validateFunction(String scriptText) {
        String scriptName = "validatedScript.groovy";
        GroovyCodeSource gcs = new GroovyCodeSource(scriptText, scriptName, DEFAULT_CODE_BASE);
        try {
            this.loader.parseClass(gcs, false);
        }
        catch (CompilationFailedException e) {
            log.warn("Groovy script validation error", e);
            if (e instanceof MultipleCompilationErrorsException) {
                return ((MultipleCompilationErrorsException)e).getErrorCollector().getErrors();
            }
            return Collections.singletonList(new ExceptionMessage(e, true, SourceUnit.create(scriptName, scriptText)));
        }
        return Collections.emptyList();
    }

    private void mergeWithContext(Binding binding, RuntimeLogger functionLogger) {
        for (Object var : this.context.getVariables().keySet()) {
            if (binding.getVariables().containsKey(var)) continue;
            binding.setVariable((String)var, this.context.getVariable((String)var));
        }
        CachedGroovyShell.appendBindedListener(binding, functionLogger);
        binding.setVariable(FunctionCode.LOG.code(), functionLogger);
    }

    private static void appendBindedListener(Binding binding, RuntimeLogger functionLogger) {
        if (binding.hasVariable(FunctionCode.LOG.code())) {
            Object variable = binding.getVariable(FunctionCode.LOG.code());
            if (functionLogger instanceof ListenableLogger) {
                ListenableLogger logger = (ListenableLogger)functionLogger;
                if (variable instanceof LogListener) {
                    LogListener bindedListener = (LogListener)variable;
                    CachedGroovyShell.removeBindedListeners(bindedListener.getClass(), logger);
                    logger.getListeners().add(bindedListener);
                }
            }
        }
    }

    private static void removeBindedListeners(Class<? extends LogListener> listenerClass, ListenableLogger logger) {
        logger.getListeners().removeIf(listenerClass::isInstance);
    }

    private CompiledGroovyFunction getCompiled(GroovyFunction function) {
        int implId = function.getImplId();
        CompiledGroovyFunction groovy = this.compileCache.get(implId);
        if (groovy == null) {
            log.debug("Groovy script: {} not found in cache, compiling", (Object)implId);
            if (this.groovySecured) {
                this.resultVerifier.verify(function);
            }
            groovy = this.compile(function);
            this.compileCache.put(implId, groovy);
        }
        return groovy;
    }

    private CompiledGroovyFunction compile(GroovyFunction function) {
        String scriptText = this.preprocessor.preprocess(function.getBody());
        String fileName = function.getVirtualName();
        GroovyCodeSource gcs = new GroovyCodeSource(scriptText, fileName, DEFAULT_CODE_BASE);
        Class<?> compiled = this.compile(gcs);
        RuntimeLogger functionLogger = this.functionLoggerCreator.createLogger(function);
        return new CompiledGroovyFunction(function.getImplId(), fileName, gcs, compiled, functionLogger);
    }

    private Class<?> compile(GroovyCodeSource codeSource) throws CompilationFailedException {
        return this.loader.parseClass(codeSource, false);
    }

    public void setVariable(String name, Object value) {
        this.context.setVariable(name, value);
    }

    public Map<Integer, CompiledGroovyFunction> getCompileCache() {
        return this.compileCache;
    }

    public Binding getContext() {
        return this.context;
    }
}

