/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.function.log;

import io.higson.runtime.function.log.FunctionLogLevel;
import io.higson.runtime.utils.Clock;
import io.higson.runtime.utils.SystemClock;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class FunctionLogLevelCache {
    public static final Duration DEFAULT_TTL = Duration.ofSeconds(30L);
    private final Map<String, CacheValue> map = new ConcurrentHashMap<String, CacheValue>();
    private final long ttl;
    private final Clock clock;

    public FunctionLogLevelCache(Duration ttl, Clock clock) {
        this.ttl = ttl.toMillis();
        this.clock = clock;
    }

    public FunctionLogLevelCache(Duration ttl) {
        this(ttl, new SystemClock());
    }

    public FunctionLogLevelCache() {
        this(DEFAULT_TTL);
    }

    public FunctionLogLevel get(String code) {
        CacheValue value = this.map.get(this.key(code));
        return value != null && this.isNotExpired(value) ? value.logLevel : null;
    }

    public void put(String code, FunctionLogLevel logLevel) {
        this.map.put(this.key(code), new CacheValue(logLevel, this.clock));
    }

    private boolean isExpired(CacheValue value) {
        return this.clock.getTime() - value.cachedAt > this.ttl;
    }

    private boolean isNotExpired(CacheValue value) {
        return !this.isExpired(value);
    }

    private String key(String code) {
        return code != null ? code : "<null>";
    }

    public String toString() {
        return "FunctionLogLevelCache[ttl=" + this.ttl + "]";
    }

    private static class CacheValue {
        private final FunctionLogLevel logLevel;
        private final long cachedAt;

        private CacheValue(FunctionLogLevel logLevel, Clock clock) {
            this.logLevel = logLevel;
            this.cachedAt = clock.getTime();
        }
    }
}

