/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.matcher;

import io.higson.runtime.engine.core.type.Type;
import io.higson.runtime.engine.core.type.ValueHolder;
import io.higson.runtime.matcher.AbstractMatcher;
import io.higson.runtime.matcher.RegexCache;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegexMatcher
extends AbstractMatcher {
    private static final Logger log = LoggerFactory.getLogger(RegexMatcher.class);
    private final RegexCache cache = new RegexCache();

    @Override
    public <T extends ValueHolder> boolean matches(String value, String pattern, Type<T> type) {
        if (this.isDefaultPattern(pattern)) {
            return true;
        }
        if (this.isBlank(pattern)) {
            return this.isBlank(value);
        }
        Pattern compiled = this.getCompiledRegex(pattern);
        if (compiled == null) {
            return false;
        }
        String val = value != null ? value : "";
        return compiled.matcher(val).matches();
    }

    private Pattern getCompiledRegex(String pattern) {
        Pattern compiled = this.cache.get(pattern);
        try {
            if (compiled == null) {
                compiled = Pattern.compile(this.patternToRegex(pattern));
                this.cache.put(pattern, compiled);
            }
            return compiled;
        }
        catch (PatternSyntaxException e) {
            log.error("Incorrect Regex in parameter matrix: {}", (Object)pattern);
            log.trace("Failed to compile regex", e);
            return null;
        }
    }

    protected String patternToRegex(String pattern) {
        return pattern;
    }

    public RegexCache getCache() {
        return this.cache;
    }
}

