/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.mp.simulation.samples;

import io.higson.runtime.mp.simulation.samples.RangeBasedSamplesException;
import io.higson.runtime.mp.simulation.samples.Samples;
import io.higson.runtime.mp.simulation.samples.iterator.BigDecimalRangeIterator;
import io.higson.runtime.mp.simulation.samples.iterator.DateRangeIterator;
import io.higson.runtime.mp.simulation.samples.iterator.IntegerRangeIterator;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Iterator;

public class RangeBasedSamples<V>
implements Samples<V> {
    private V min;
    private V max;
    private BigDecimal step;
    private Class<V> type;
    private String stepType;

    public RangeBasedSamples(Class<V> type, V min, V max, BigDecimal step) {
        this.type = type;
        this.min = min;
        this.max = max;
        this.step = step;
    }

    public RangeBasedSamples(Class<V> type, V min, V max, BigDecimal step, String stepType) {
        this(type, min, max, step);
        this.stepType = stepType;
    }

    @Override
    public Iterator<V> iterator() {
        if (BigDecimal.class.equals(this.type)) {
            return new BigDecimalRangeIterator(this);
        }
        if (Integer.class.equals(this.type)) {
            return new IntegerRangeIterator(this);
        }
        if (Date.class.equals(this.type)) {
            return new DateRangeIterator(this, this.stepType == null ? "" : this.stepType);
        }
        throw new RangeBasedSamplesException("input series cannot be used for iteration or is not correctly defined in Context");
    }

    public V getMin() {
        return this.min;
    }

    public V getMax() {
        return this.max;
    }

    public BigDecimal getStep() {
        return this.step;
    }

    public Class<V> getType() {
        return this.type;
    }

    public String getStepType() {
        return this.stepType;
    }
}

