/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.profiler;

import io.higson.runtime.profiler.AbstractProfilerStat;
import io.higson.runtime.profiler.ProfilerHelper;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public abstract class AbstractProfiler<T, S extends AbstractProfilerStat<T>> {
    private static final int INITIAL_CAPACITY = 128;
    protected Map<T, S> map = new HashMap<T, S>(128);

    public synchronized void addTime(T key, long time) {
        AbstractProfilerStat stat;
        if (key == null) {
            key = this.getNullKey();
        }
        if (Objects.isNull(stat = (AbstractProfilerStat)this.map.get(key))) {
            stat = (AbstractProfilerStat)this.getKeyStatsSupplier().apply(key);
            this.map.put(key, stat);
        }
        stat.addTime(time);
    }

    public synchronized void addTime(T key, long t1, long t2) {
        this.addTime(key, t2 - t1);
    }

    public synchronized void clear() {
        this.map.clear();
    }

    public synchronized S getStat(T key) {
        AbstractProfilerStat stat = (AbstractProfilerStat)this.map.get(key);
        return (S)(stat != null ? (AbstractProfilerStat)this.getStatsSupplier().apply(stat) : null);
    }

    public synchronized String printSummary() {
        return this.printSummary("Profiler summary");
    }

    public String printSummary(String title) {
        List<S> stats = this.getStatistics();
        return this.printSummary(stats, title);
    }

    public String printSummary(List<S> statistics, String title) {
        return ProfilerHelper.printSummary(statistics, title);
    }

    public List<S> getStatistics() {
        List<S> stats = this.getStats();
        return this.sort(stats);
    }

    private List<S> getStats() {
        ArrayList<AbstractProfilerStat> list = new ArrayList<AbstractProfilerStat>(this.map.size());
        for (AbstractProfilerStat stat : this.map.values()) {
            list.add((AbstractProfilerStat)this.getStatsSupplier().apply(stat));
        }
        return list;
    }

    public List<S> sort(List<S> stats) {
        stats.sort(this.getComparator());
        return stats;
    }

    public abstract Comparator<S> getComparator();

    public abstract T getNullKey();

    public abstract Function<S, S> getStatsSupplier();

    public abstract Function<T, S> getKeyStatsSupplier();
}

