/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.provider;

import io.higson.runtime.dao.FunctionJdbcDao;
import io.higson.runtime.dao.VersionJdbcDao;
import io.higson.runtime.dao.parameter.ParameterJdbcDao;
import io.higson.runtime.model.Element;
import io.higson.runtime.model.Function;
import io.higson.runtime.model.Parameter;
import io.higson.runtime.model.RegionVersion;
import io.higson.runtime.model.Schedule;
import io.higson.runtime.model.region.ScheduleContainer;
import io.higson.runtime.sync.ScheduleCache;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MpScheduleProvider {
    private static final Logger log = LoggerFactory.getLogger(MpScheduleProvider.class);
    private final VersionJdbcDao vdao;
    private final ParameterJdbcDao pdao;
    private final FunctionJdbcDao fdao;
    private AtomicReference<ScheduleCache> cache = new AtomicReference();

    ScheduleCache createScheduleCache() {
        log.debug("creating schedule cache...");
        Map<Integer, RegionVersion> versionMap = this.vdao.getAllRegionVersions();
        Map<String, ScheduleContainer> scheduleMap = this.vdao.getAllSchedules();
        List<Parameter> params = this.pdao.getAllHeads();
        List<Function> functions = this.fdao.getAllHeads();
        Map<String, Schedule> parSchedules = this.mapCodesToSchedules(params, versionMap, scheduleMap);
        Map<String, Schedule> funSchedules = this.mapCodesToSchedules(functions, versionMap, scheduleMap);
        int hash = this.computeHash(scheduleMap);
        ScheduleCache scheduleCache = new ScheduleCache(parSchedules, funSchedules, scheduleMap, hash, versionMap.values());
        log.debug("created schedule cache: {}", (Object)scheduleCache);
        return scheduleCache;
    }

    public int computeHash() {
        Map<String, ScheduleContainer> scheduleMap = this.vdao.getAllSchedules();
        return this.computeHash(scheduleMap);
    }

    public int computeHash(Map<String, ScheduleContainer> scheduleMap) {
        Date parLastupdate = this.pdao.getMaxLastUpdate();
        Date funLastupdate = this.fdao.getMaxLastUpdate();
        return this.computeHash(scheduleMap, parLastupdate, funLastupdate);
    }

    public int hash() {
        ScheduleCache scheduleCache = this.cache.get();
        return scheduleCache != null ? scheduleCache.getHash() : 0;
    }

    public void reload() {
        this.cache.set(this.createScheduleCache());
    }

    public ScheduleCache cache() {
        if (this.cache.get() == null) {
            this.reload();
        }
        return this.cache.get();
    }

    private int computeHash(Map<String, ScheduleContainer> scheduleMap, Date ... lastupdates) {
        int hash = scheduleMap.hashCode();
        for (Date date : lastupdates) {
            hash = 31 * hash + this.h(date != null ? date.getTime() : 0L);
        }
        return hash;
    }

    private int h(long v) {
        int h = (int)(v ^ v >>> 32);
        return h ^ h >>> 7 ^ h >>> 4;
    }

    private <E extends Element> Map<String, Schedule> mapCodesToSchedules(List<E> items, Map<Integer, RegionVersion> versionMap, Map<String, ScheduleContainer> scheduleMap) {
        HashMap<String, Schedule> result = new HashMap<String, Schedule>();
        for (Element item : items) {
            int rvid = item.getRegionVersionId();
            RegionVersion rv = versionMap.get(rvid);
            if (rv == null || rv.getRegion() == null) continue;
            Schedule sch = this.getSchedule(scheduleMap, rv.getProfileCode(), rv.getRegion());
            result.put(item.getName(), sch);
        }
        return result;
    }

    private Schedule getSchedule(Map<String, ScheduleContainer> map, String profileCode, String regionCode) {
        return map.computeIfAbsent(profileCode, code -> this.createScheduleContainerWithSchedule((String)code, regionCode)).getSchedule(regionCode).orElseGet(this.createSchedule(map, profileCode, regionCode));
    }

    private ScheduleContainer createScheduleContainerWithSchedule(String profileCode, String regionCode) {
        ScheduleContainer container = new ScheduleContainer();
        Schedule schedule = new Schedule(profileCode, regionCode);
        container.add(regionCode, schedule);
        return container;
    }

    private Supplier<Schedule> createSchedule(Map<String, ScheduleContainer> map, String profileCode, String regionCode) {
        return () -> {
            Schedule schedule = new Schedule(profileCode, regionCode);
            ((ScheduleContainer)map.get(profileCode)).add(regionCode, schedule);
            return schedule;
        };
    }

    public MpScheduleProvider(VersionJdbcDao vdao, ParameterJdbcDao pdao, FunctionJdbcDao fdao) {
        this.vdao = vdao;
        this.pdao = pdao;
        this.fdao = fdao;
    }
}

