/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.provider.external;

import io.higson.runtime.core.extdatasource.ExternalDataSourceProvider;
import io.higson.runtime.dao.MiniJdbcTemplate;
import io.higson.runtime.dao.util.ConnectionInterceptor;
import io.higson.runtime.engine.core.parameter.ParameterEntry;
import io.higson.runtime.engine.core.type.ValueHolder;
import io.higson.runtime.helper.TypeConverter;
import io.higson.runtime.model.MpParameterEntry;
import io.higson.runtime.model.Parameter;
import io.higson.runtime.model.ParameterLevel;
import io.higson.runtime.provider.external.ExtRowCallbackHandler;
import io.higson.runtime.provider.external.ExtSql;
import io.higson.runtime.provider.external.ExtSqlParser;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtSqlExecutor {
    private static final Logger log = LoggerFactory.getLogger(ExtSqlExecutor.class);
    private static final int DEFAULT_FETCH_SIZE = 100;
    private static final int MATRIX_FETCH_SIZE = 500;
    private final TypeConverter typeConverter = TypeConverter.getInstance();
    private final ExternalDataSourceProvider dataSourceProvider;
    private final ConnectionInterceptor connectionInterceptor;

    public Set<ParameterEntry> findEntries(Parameter def, String[] inputValues) {
        if (log.isDebugEnabled()) {
            log.debug("finding entries for param={}, input values={}", (Object)def.getName(), (Object)Arrays.deepToString(inputValues));
        }
        boolean trace = log.isTraceEnabled();
        String template = def.getExternalNonMemQuery();
        log.trace("using ext non-mem query: {}", (Object)template);
        ExtSql ext = ExtSqlParser.parse(template);
        Object[] args = this.getQueryArguments(def, inputValues, trace, ext);
        HashSet<ParameterEntry> result = new HashSet<ParameterEntry>(8);
        int outCnt = def.getOutputLevels();
        this.getJdbcTemplate(def).query(ext.getSql(), args, rs -> {
            String[] out = new String[outCnt];
            for (int i = 0; i < outCnt; ++i) {
                Object obj = rs.getObject(i + 1);
                String text = null;
                if (obj != null) {
                    ParameterLevel parameterLevel = def.getOutputLevel(i);
                    text = this.typeConverter.toHolder(obj, parameterLevel.getType()).getString();
                }
                out[i] = text;
                if (!trace) continue;
                log.trace("reading out[{}]: {} ({}) -> {} (String)", i, obj, this.className(obj), text);
            }
            String[] row = this.merge(inputValues, out);
            result.add(new MpParameterEntry(row));
        });
        if (log.isDebugEnabled()) {
            log.debug("finished finding entries, result = {}", (Object)result);
        }
        return result;
    }

    private MiniJdbcTemplate getJdbcTemplate(Parameter def) {
        DataSource dataSource = this.dataSourceProvider.getDataSource(def.getExternalDataSource());
        MiniJdbcTemplate jdbcTemplate = new MiniJdbcTemplate(dataSource, this.connectionInterceptor);
        jdbcTemplate.setFetchSize(100);
        return jdbcTemplate;
    }

    private Object[] getQueryArguments(Parameter def, String[] inputValues, boolean trace, ExtSql ext) {
        int argCnt = ext.getArgNumber();
        Object[] args = new Object[argCnt];
        for (int i = 0; i < argCnt; ++i) {
            String argName = ext.getArg(i);
            int levelIx = def.getInputLevelIndex(argName);
            ParameterLevel parameterLevel = def.getLevel(levelIx);
            String textValue = inputValues[levelIx];
            Object argValue = this.castArgToType(textValue, parameterLevel);
            if (trace) {
                log.trace("binding arg: {} ({}) -> {} ({})", argName, parameterLevel.getType(), argValue, this.className(argValue));
            }
            args[i] = argValue;
        }
        return args;
    }

    public void fetchMatrixExt(Parameter p) {
        log.debug("enter fetchMatrixExt, p={}", (Object)p);
        long pid = p.getId();
        String sql = p.getExternalInMemQuery();
        DataSource dataSource = this.dataSourceProvider.getDataSource(p.getExternalDataSource());
        log.trace("using datasource: {}", (Object)dataSource);
        log.trace("using query: {}", (Object)sql);
        MiniJdbcTemplate jdbc = new MiniJdbcTemplate(dataSource, this.connectionInterceptor);
        jdbc.setFetchSize(500);
        jdbc.query(sql, new ExtRowCallbackHandler(p));
        log.debug("leave fetchMatrixExt, pid={}, size={}", (Object)pid, (Object)p.getEntries().size());
    }

    final String[] merge(String[] a, String[] b) {
        String[] r = new String[a.length + b.length];
        System.arraycopy(a, 0, r, 0, a.length);
        System.arraycopy(b, 0, r, a.length, b.length);
        return r;
    }

    private String className(Object obj) {
        return obj != null ? obj.getClass().getSimpleName() : null;
    }

    private Object castArgToType(String textValue, ParameterLevel parameterLevel) {
        if (StringUtils.isBlank(textValue)) {
            return null;
        }
        String type = parameterLevel.getType();
        ValueHolder holder = this.typeConverter.toHolder((Object)textValue, type);
        return holder.getValue();
    }

    public ExtSqlExecutor(ExternalDataSourceProvider dataSourceProvider, ConnectionInterceptor connectionInterceptor) {
        this.dataSourceProvider = dataSourceProvider;
        this.connectionInterceptor = connectionInterceptor;
    }
}

