/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.sync;

import io.higson.runtime.core.domain.WatcherDomainCacheManager;
import io.higson.runtime.sync.BaseWatcher;
import io.higson.runtime.sync.DomainWatcherConfig;

public class DomainRuntimeWatcher
extends BaseWatcher {
    private final WatcherDomainCacheManager cacheManager;

    public DomainRuntimeWatcher(WatcherDomainCacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    @Override
    protected String getWatcherName() {
        return "domain-watcher";
    }

    @Override
    public void doWatch() {
        this.log.debug("starting domain watcher");
        this.cacheManager.doWatch();
        DomainWatcherConfig domainWatcherConfig = (DomainWatcherConfig)this.getConfig();
        this.cacheManager.invalidateTreeVersionCachesAfter(domainWatcherConfig.getTreeLifespanTime(), domainWatcherConfig.getTreeLifespanTimeUnit());
        this.log.debug("domain watcher finished");
    }
}

