/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.sync;

import io.higson.runtime.engine.core.function.FunctionCache;
import io.higson.runtime.engine.core.prepared.CacheEntry;
import io.higson.runtime.invoker.GroovyFunctionInvoker;
import io.higson.runtime.model.Function;
import io.higson.runtime.prefetch.Initializer;
import io.higson.runtime.provider.MpFunctionProvider;
import io.higson.runtime.sync.RuntimeWatcher;
import io.higson.runtime.sync.RuntimeWatcherHelper;
import io.higson.runtime.sync.Trackable;
import io.higson.runtime.sync.event.ElementType;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class FunctionRuntimeWatcher
extends RuntimeWatcher {
    private final MpFunctionProvider provider;
    private final FunctionCache cache;
    private final GroovyFunctionInvoker groovyFunctionInvoker;
    private final Initializer initializer;

    public FunctionRuntimeWatcher(MpFunctionProvider provider, FunctionCache cache, GroovyFunctionInvoker groovyFunctionInvoker, Initializer initializer) {
        this.provider = provider;
        this.cache = cache;
        this.groovyFunctionInvoker = groovyFunctionInvoker;
        this.initializer = initializer;
    }

    @Override
    protected String getWatcherName() {
        return "function-watcher";
    }

    @Override
    public List<Trackable> getAllCached() {
        List<CacheEntry<io.higson.runtime.engine.core.function.Function>> all = this.cache.list();
        this.log.trace("fetched {} functions from cache", (Object)all.size());
        ArrayList<Trackable> result = new ArrayList<Trackable>(all.size());
        for (CacheEntry<io.higson.runtime.engine.core.function.Function> entry : all) {
            String key = entry.getKey();
            Function f = (Function)entry.getValue();
            result.add(new Trackable(f.getId(), key, f.getLastupdate()));
        }
        return result;
    }

    @Override
    public void invalidate(int id) {
        RuntimeWatcherHelper.invalidateFunction(this.cache, id);
        this.invalidateCompileCache(id);
    }

    @Override
    public Date getLastUpdate() {
        return this.provider.getLastUpdate();
    }

    @Override
    public List<Trackable> getAllLastUpdates() {
        return this.provider.getAllLastUpdates();
    }

    @Override
    public ElementType getElementType() {
        return ElementType.FUNCTION;
    }

    private void invalidateCompileCache(int functionId) {
        this.groovyFunctionInvoker.invalidate(functionId);
    }

    @Override
    public void reload(String code) {
        this.initializer.initialize(code);
    }
}

