/*
 * Decompiled with CFR 0.152.
 */
package io.higson.runtime.utils;

public final class Location {
    private static final double DEFAULT_ELEVATION = 0.0;
    private final double latitude;
    private final double longitude;
    private final double elevation;

    public Location(double latitude, double longitude) {
        this(latitude, longitude, 0.0);
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public double getElevation() {
        return this.elevation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Location)) {
            return false;
        }
        Location other = (Location)o;
        if (Double.compare(this.getLatitude(), other.getLatitude()) != 0) {
            return false;
        }
        if (Double.compare(this.getLongitude(), other.getLongitude()) != 0) {
            return false;
        }
        return Double.compare(this.getElevation(), other.getElevation()) == 0;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $latitude = Double.doubleToLongBits(this.getLatitude());
        result = result * 59 + (int)($latitude >>> 32 ^ $latitude);
        long $longitude = Double.doubleToLongBits(this.getLongitude());
        result = result * 59 + (int)($longitude >>> 32 ^ $longitude);
        long $elevation = Double.doubleToLongBits(this.getElevation());
        result = result * 59 + (int)($elevation >>> 32 ^ $elevation);
        return result;
    }

    public String toString() {
        return "Location(latitude=" + this.getLatitude() + ", longitude=" + this.getLongitude() + ", elevation=" + this.getElevation() + ")";
    }

    public Location(double latitude, double longitude, double elevation) {
        this.latitude = latitude;
        this.longitude = longitude;
        this.elevation = elevation;
    }
}

