/*
 * Decompiled with CFR 0.152.
 */
package jep;

import java.io.File;
import java.util.Map;
import jep.ClassEnquirer;
import jep.ClassList;
import jep.Interpreter;
import jep.JepConfig;
import jep.JepException;
import jep.MainInterpreter;
import jep.PyConfig;
import jep.python.MemoryManager;

public class Jep
implements Interpreter {
    private static final String THREAD_WARN = "JEP THREAD WARNING: ";
    private boolean closed = false;
    private long tstate = 0L;
    private Thread thread = null;
    private ClassLoader classLoader = null;
    private StringBuilder evalLines = null;
    private boolean interactive = false;
    private final MemoryManager memoryManager = new MemoryManager();
    private final boolean isSubInterpreter;
    private static final String LINE_SEP = "\n";
    private static final ThreadLocal<Boolean> threadUsed = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    @Deprecated
    public static void setInitParams(PyConfig pyConfig) throws JepException {
        MainInterpreter.setInitParams(pyConfig);
    }

    @Deprecated
    public static void setSharedModulesArgv(String ... stringArray) throws JepException {
        MainInterpreter.setSharedModulesArgv(stringArray);
    }

    @Deprecated
    public Jep() throws JepException {
        this(new JepConfig());
    }

    @Deprecated
    public Jep(boolean bl) throws JepException {
        this(bl, null, null);
    }

    @Deprecated
    public Jep(boolean bl, String string) throws JepException {
        this(bl, string, null);
    }

    @Deprecated
    public Jep(boolean bl, String string, ClassLoader classLoader) throws JepException {
        this(bl, string, classLoader, null);
    }

    @Deprecated
    public Jep(boolean bl, String string, ClassLoader classLoader, ClassEnquirer classEnquirer) throws JepException {
        this(new JepConfig().setInteractive(bl).setIncludePath(string).setClassLoader(classLoader).setClassEnquirer(classEnquirer));
    }

    @Deprecated
    public Jep(JepConfig jepConfig) throws JepException {
        this(jepConfig, true);
    }

    protected Jep(JepConfig jepConfig, boolean bl) throws JepException {
        MainInterpreter mainInterpreter = MainInterpreter.getMainInterpreter();
        if (threadUsed.get().booleanValue()) {
            Thread thread = Thread.currentThread();
            StringBuilder stringBuilder = new StringBuilder(THREAD_WARN).append("Unsafe reuse of thread ").append(thread.getName()).append(" for another Python sub-interpreter.\n").append("Please close() the previous Jep instance to ensure stability.");
            throw new JepException(stringBuilder.toString());
        }
        this.isSubInterpreter = bl;
        this.classLoader = jepConfig.classLoader == null ? this.getClass().getClassLoader() : jepConfig.classLoader;
        boolean bl2 = jepConfig.sharedModules != null && !jepConfig.sharedModules.isEmpty();
        this.interactive = jepConfig.interactive;
        this.tstate = this.init(this.classLoader, bl2, bl);
        threadUsed.set(true);
        this.thread = Thread.currentThread();
        this.configureInterpreter(jepConfig);
    }

    protected void configureInterpreter(JepConfig jepConfig) throws JepException {
        if (jepConfig.includePath != null) {
            String string = jepConfig.includePath.toString();
            if (string.contains("\\")) {
                string = string.replace("\\", "\\\\");
            }
            this.exec("import sys");
            this.exec("sys.path += '" + string + "'.split('" + File.pathSeparator + "')");
        }
        boolean bl = jepConfig.sharedModules != null && !jepConfig.sharedModules.isEmpty();
        this.eval("import jep");
        if (bl) {
            this.set("sharedModules", jepConfig.sharedModules);
            this.set("sharedImporter", MainInterpreter.getMainInterpreter());
            this.exec("jep.shared_modules_hook.setupImporter(sharedModules,sharedImporter)");
            this.exec("del sharedModules");
            this.exec("del sharedImporter");
        }
        this.setupJavaImportHook(jepConfig.classEnquirer);
        if (jepConfig.redirectOutputStreams) {
            this.exec("from jep import redirect_streams");
            this.exec("redirect_streams.setup()");
        }
    }

    protected void setupJavaImportHook(ClassEnquirer classEnquirer) throws JepException {
        if (classEnquirer == null) {
            classEnquirer = ClassList.getInstance();
        }
        this.set("classlist", classEnquirer);
        this.exec("from jep import java_import_hook");
        this.exec("java_import_hook.setupImporter(classlist)");
        this.exec("del classlist");
        this.exec("del java_import_hook");
    }

    private native long init(ClassLoader var1, boolean var2, boolean var3) throws JepException;

    @Deprecated
    public void isValidThread() throws JepException {
        if (this.thread != Thread.currentThread()) {
            throw new JepException("Invalid thread access.");
        }
        if (this.closed) {
            throw new JepException("Jep instance has been closed.");
        }
        if (this.tstate == 0L) {
            throw new JepException("Initialization failed.");
        }
    }

    @Override
    public void runScript(String string) throws JepException {
        this.runScript(string, null);
    }

    @Deprecated
    public void runScript(String string, ClassLoader classLoader) throws JepException {
        this.isValidThread();
        if (string == null) {
            throw new JepException("Script filename cannot be null.");
        }
        File file = new File(string);
        if (!file.exists() || !file.canRead()) {
            throw new JepException("Invalid file: " + file.getAbsolutePath());
        }
        this.setClassLoader(classLoader);
        this.run(this.tstate, string);
    }

    private native void run(long var1, String var3) throws JepException;

    @Override
    public Object invoke(String string, Object ... objectArray) throws JepException {
        this.isValidThread();
        if (string == null || string.trim().equals("")) {
            throw new JepException("Invalid function name.");
        }
        return this.invoke(this.tstate, string, objectArray, null);
    }

    @Override
    public Object invoke(String string, Map<String, Object> map) throws JepException {
        this.isValidThread();
        if (string == null || string.trim().equals("")) {
            throw new JepException("Invalid function name.");
        }
        return this.invoke(this.tstate, string, null, map);
    }

    @Override
    public Object invoke(String string, Object[] objectArray, Map<String, Object> map) throws JepException {
        this.isValidThread();
        if (string == null || string.trim().equals("")) {
            throw new JepException("Invalid function name.");
        }
        return this.invoke(this.tstate, string, objectArray, map);
    }

    private native Object invoke(long var1, String var3, Object[] var4, Map<String, Object> var5);

    @Override
    public boolean eval(String string) throws JepException {
        this.isValidThread();
        try {
            if (string != null) {
                string = string.replaceAll("\r", "");
            }
            if (string == null || string.trim().equals("")) {
                if (!this.interactive) {
                    return false;
                }
                if (this.evalLines == null) {
                    return true;
                }
                this.eval(this.tstate, this.evalLines.toString());
                this.evalLines = null;
                return true;
            }
            if (!this.interactive || this.evalLines == null && this.compileString(this.tstate, string) == 1) {
                this.eval(this.tstate, string);
                return true;
            }
            if (this.evalLines == null) {
                this.evalLines = new StringBuilder();
            } else {
                this.evalLines.append(LINE_SEP);
            }
            this.evalLines.append(string);
            return false;
        }
        catch (JepException jepException) {
            this.evalLines = null;
            throw jepException;
        }
    }

    private native int compileString(long var1, String var3) throws JepException;

    private native void eval(long var1, String var3) throws JepException;

    @Override
    public void exec(String string) throws JepException {
        this.isValidThread();
        this.exec(this.tstate, string);
    }

    private native void exec(long var1, String var3) throws JepException;

    @Override
    public Object getValue(String string) throws JepException {
        this.isValidThread();
        return this.getValue(this.tstate, string, Object.class);
    }

    @Override
    public <T> T getValue(String string, Class<T> clazz) throws JepException {
        this.isValidThread();
        return clazz.cast(this.getValue(this.tstate, string, clazz));
    }

    private native Object getValue(long var1, String var3, Class<?> var4) throws JepException;

    @Deprecated
    public byte[] getValue_bytearray(String string) throws JepException {
        this.isValidThread();
        return this.getValue_bytearray(this.tstate, string);
    }

    private native byte[] getValue_bytearray(long var1, String var3) throws JepException;

    private native long createModule(long var1, String var3) throws JepException;

    @Deprecated
    public void setClassLoader(ClassLoader classLoader) {
        if (classLoader != null && classLoader != this.classLoader) {
            this.classLoader = classLoader;
            this.setClassLoader(this.tstate, classLoader);
        }
    }

    private native void setClassLoader(long var1, ClassLoader var3);

    @Deprecated
    public void setInteractive(boolean bl) {
        this.interactive = bl;
    }

    @Deprecated
    public boolean isInteractive() {
        return this.interactive;
    }

    @Override
    public void set(String string, Object object) throws JepException {
        this.isValidThread();
        if (object instanceof Class) {
            this.set(this.tstate, string, (Class)object);
        } else if (object instanceof String) {
            this.set(string, (String)object);
        } else if (object instanceof Float) {
            this.set(string, ((Float)object).floatValue());
        } else if (object instanceof Integer) {
            this.set(string, (Integer)object);
        } else if (object instanceof Double) {
            this.set(string, (Double)object);
        } else if (object instanceof Long) {
            this.set(string, (Long)object);
        } else if (object instanceof Byte) {
            this.set(string, (Byte)object);
        } else if (object instanceof Short) {
            this.set(string, (Short)object);
        } else if (object instanceof Boolean) {
            this.set(string, (Boolean)object);
        } else {
            this.set(this.tstate, string, object);
        }
    }

    private native void set(long var1, String var3, Object var4) throws JepException;

    private native void set(long var1, String var3, Class<?> var4) throws JepException;

    @Deprecated
    public void set(String string, String string2) throws JepException {
        this.isValidThread();
        this.set(this.tstate, string, string2);
    }

    private native void set(long var1, String var3, String var4) throws JepException;

    @Deprecated
    public void set(String string, boolean bl) throws JepException {
        this.isValidThread();
        this.set(this.tstate, string, bl);
    }

    private native void set(long var1, String var3, boolean var4) throws JepException;

    @Deprecated
    public void set(String string, int n) throws JepException {
        this.isValidThread();
        this.set(this.tstate, string, n);
    }

    @Deprecated
    public void set(String string, short s) throws JepException {
        this.isValidThread();
        this.set(this.tstate, string, s);
    }

    private native void set(long var1, String var3, int var4) throws JepException;

    @Deprecated
    public void set(String string, char[] cArray) throws JepException {
        this.isValidThread();
        this.set(this.tstate, string, new String(cArray));
    }

    @Deprecated
    public void set(String string, char c) throws JepException {
        this.isValidThread();
        this.set(this.tstate, string, new String(new char[]{c}));
    }

    @Deprecated
    public void set(String string, byte by) throws JepException {
        this.isValidThread();
        this.set(this.tstate, string, by);
    }

    @Deprecated
    public void set(String string, long l) throws JepException {
        this.isValidThread();
        this.set(this.tstate, string, l);
    }

    private native void set(long var1, String var3, long var4) throws JepException;

    @Deprecated
    public void set(String string, double d) throws JepException {
        this.isValidThread();
        this.set(this.tstate, string, d);
    }

    private native void set(long var1, String var3, double var4) throws JepException;

    @Deprecated
    public void set(String string, float f) throws JepException {
        this.isValidThread();
        this.set(this.tstate, string, f);
    }

    private native void set(long var1, String var3, float var4) throws JepException;

    @Deprecated
    public void set(String string, boolean[] blArray) throws JepException {
        this.isValidThread();
        this.set(this.tstate, string, blArray);
    }

    private native void set(long var1, String var3, boolean[] var4) throws JepException;

    @Deprecated
    public void set(String string, int[] nArray) throws JepException {
        this.isValidThread();
        this.set(this.tstate, string, nArray);
    }

    private native void set(long var1, String var3, int[] var4) throws JepException;

    @Deprecated
    public void set(String string, short[] sArray) throws JepException {
        this.isValidThread();
        this.set(this.tstate, string, sArray);
    }

    private native void set(long var1, String var3, short[] var4) throws JepException;

    @Deprecated
    public void set(String string, byte[] byArray) throws JepException {
        this.isValidThread();
        this.set(this.tstate, string, byArray);
    }

    private native void set(long var1, String var3, byte[] var4) throws JepException;

    @Deprecated
    public void set(String string, long[] lArray) throws JepException {
        this.isValidThread();
        this.set(this.tstate, string, lArray);
    }

    private native void set(long var1, String var3, long[] var4) throws JepException;

    @Deprecated
    public void set(String string, double[] dArray) throws JepException {
        this.isValidThread();
        this.set(this.tstate, string, dArray);
    }

    private native void set(long var1, String var3, double[] var4) throws JepException;

    @Deprecated
    public void set(String string, float[] fArray) throws JepException {
        this.isValidThread();
        this.set(this.tstate, string, fArray);
    }

    private native void set(long var1, String var3, float[] var4) throws JepException;

    protected MemoryManager getMemoryManager() {
        return this.memoryManager;
    }

    protected long getThreadState() {
        return this.tstate;
    }

    protected ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public synchronized void close() throws JepException {
        if (this.closed) {
            return;
        }
        if (!Thread.currentThread().equals(this.thread)) {
            Thread thread = Thread.currentThread();
            StringBuilder stringBuilder = new StringBuilder(THREAD_WARN).append("Unsafe close() of Python sub-interpreter by thread ").append(thread.getName()).append(".\nPlease close() from the creating thread to ensure stability.");
            throw new JepException(stringBuilder.toString());
        }
        if (this.isSubInterpreter) {
            Integer n;
            this.exec("import sys");
            Boolean bl = this.getValue("'threading' in sys.modules", Boolean.class);
            if (bl.booleanValue() && (n = this.getValue("sys.modules['threading'].active_count()", Integer.class)) > 1) {
                throw new JepException("All threads must be stopped before closing Jep.");
            }
        }
        this.getMemoryManager().cleanupReferences();
        this.closed = true;
        if (this.isSubInterpreter) {
            this.exec(this.tstate, "import jep");
            this.exec(this.tstate, "jep.shared_modules_hook.teardownImporter()");
        }
        this.close(this.tstate);
        this.tstate = 0L;
        threadUsed.set(false);
    }

    private native void close(long var1);
}

