/*
 * Decompiled with CFR 0.152.
 */
package jep.python;

import java.lang.ref.ReferenceQueue;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Set;
import jep.JepException;
import jep.python.PyObject;
import jep.python.PyPointer;

public final class MemoryManager {
    private ReferenceQueue<PyObject> refQueue = new ReferenceQueue();
    private Set<PyPointer> pointers = Collections.newSetFromMap(new IdentityHashMap());

    protected ReferenceQueue<PyObject> getReferenceQueue() throws JepException {
        this.cleanupWeakReferences();
        return this.refQueue;
    }

    protected void addReference(PyPointer pyPointer) {
        this.pointers.add(pyPointer);
    }

    protected void removeReference(PyPointer pyPointer) {
        this.pointers.remove(pyPointer);
    }

    public void cleanupReferences() throws JepException {
        Iterator<PyPointer> iterator = this.pointers.iterator();
        while (iterator.hasNext()) {
            PyPointer pyPointer = iterator.next();
            iterator.remove();
            pyPointer.dispose();
        }
    }

    public void cleanupWeakReferences() throws JepException {
        PyPointer pyPointer = (PyPointer)this.refQueue.poll();
        while (pyPointer != null) {
            pyPointer.dispose();
            pyPointer = (PyPointer)this.refQueue.poll();
        }
    }
}

