/*
 * Decompiled with CFR 0.152.
 */
package org.smartparam.engine.core;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.smartparam.engine.config.pico.FunctionRuntimeConfigParameters;
import org.smartparam.engine.config.pico.ParamRuntimeConfigParameters;
import org.smartparam.engine.core.function.FunctionCache;
import org.smartparam.engine.core.function.FunctionInvoker;
import org.smartparam.engine.core.function.FunctionRepository;
import org.smartparam.engine.core.matcher.Matcher;
import org.smartparam.engine.core.parameter.ParamRepository;
import org.smartparam.engine.core.prepared.ParamPreparer;
import org.smartparam.engine.core.prepared.PreparedParamCache;
import org.smartparam.engine.core.type.Type;
import org.smartparam.engine.core.type.ValueHolder;

public class ParamEngineRuntimeConfig {
    private final FunctionCache functionCache;
    private final PreparedParamCache paramCache;
    private final ParamPreparer paramPreparer;
    private final Map<String, FunctionInvoker> invokers;
    private final Map<String, Type<?>> types;
    private final Map<String, Matcher> matchers;
    private final Map<String, FunctionRepository> functionRepositories;
    private final List<ParamRepository> paramRepositories;

    public ParamEngineRuntimeConfig(ParamRuntimeConfigParameters paramParameters, FunctionRuntimeConfigParameters functionParameters, Map<String, FunctionInvoker> invokers, Map<String, Type<? extends ValueHolder>> types, Map<String, Matcher> matchers) {
        this.functionCache = functionParameters.getFunctionCache();
        this.paramCache = paramParameters.getParamCache();
        this.paramPreparer = paramParameters.getParamPreparer();
        this.functionRepositories = Collections.unmodifiableMap(functionParameters.getFunctionRepositories());
        this.paramRepositories = Collections.unmodifiableList(paramParameters.getParamRepositories());
        this.invokers = Collections.unmodifiableMap(invokers);
        this.types = Collections.unmodifiableMap(types);
        this.matchers = Collections.unmodifiableMap(matchers);
    }

    public FunctionCache getFunctionCache() {
        return this.functionCache;
    }

    public PreparedParamCache getParamCache() {
        return this.paramCache;
    }

    public ParamPreparer getParamPreparer() {
        return this.paramPreparer;
    }

    public Map<String, FunctionInvoker> getInvokers() {
        return this.invokers;
    }

    public Map<String, Type<?>> getTypes() {
        return this.types;
    }

    public Map<String, Matcher> getMatchers() {
        return this.matchers;
    }

    public Map<String, FunctionRepository> getFunctionRepositories() {
        return this.functionRepositories;
    }

    public List<ParamRepository> getParamRepositories() {
        return this.paramRepositories;
    }
}

