/*
 * Decompiled with CFR 0.152.
 */
package org.smartparam.engine.core.type;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import org.smartparam.engine.core.type.ValueHolder;

public abstract class AbstractValueHolder
implements ValueHolder {
    private static final int EXPECTED_TOSTRING_LENGTH = 32;

    @Override
    public boolean isNull() {
        return this.getValue() == null;
    }

    @Override
    public boolean isNotNull() {
        return this.getValue() != null;
    }

    @Override
    public boolean isBlank() {
        return this.isNull();
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass() == this.getClass()) {
            Object v1 = this.getValue();
            Object v2 = ((ValueHolder)obj).getValue();
            if (v1 == null) {
                return v2 == null;
            }
            if (v2 != null) {
                return v1.equals(v2);
            }
        }
        return false;
    }

    public int hashCode() {
        Object v = this.getValue();
        int vhash = v != null ? v.hashCode() : 1;
        return this.getClass().hashCode() ^ vhash;
    }

    @Override
    public boolean isComparable() {
        return true;
    }

    @Override
    public int compareTo(ValueHolder o) {
        if (this.isComparable()) {
            Comparable v1 = (Comparable)this.getValue();
            Comparable v2 = (Comparable)o.getValue();
            if (v1 != null) {
                return v2 != null ? v1.compareTo(v2) : 1;
            }
            return v2 != null ? -1 : 0;
        }
        return 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(32);
        sb.append(this.getClass().getSimpleName());
        sb.append('[').append(this.getString()).append(']');
        return sb.toString();
    }

    private UnsupportedOperationException prepareUnexpectedUsageException(String valueType) {
        return new UnsupportedOperationException(String.format("Trying to get [%s] value from %s, which does not support this type. Check if type of parameter level is correct.", valueType, this.getClass()));
    }

    @Override
    public String getString() {
        Object value = this.getValue();
        return value != null ? value.toString() : null;
    }

    @Override
    public int intValue() {
        throw this.prepareUnexpectedUsageException("int");
    }

    @Override
    public long longValue() {
        throw this.prepareUnexpectedUsageException("long");
    }

    @Override
    public double doubleValue() {
        throw this.prepareUnexpectedUsageException("double");
    }

    @Override
    public boolean booleanValue() {
        throw this.prepareUnexpectedUsageException("boolean");
    }

    @Override
    public Integer getInteger() {
        throw this.prepareUnexpectedUsageException("Integer");
    }

    @Override
    public Long getLong() {
        throw this.prepareUnexpectedUsageException("Long");
    }

    @Override
    public Double getDouble() {
        throw this.prepareUnexpectedUsageException("Double");
    }

    @Override
    public Boolean getBoolean() {
        throw this.prepareUnexpectedUsageException("Boolean");
    }

    @Override
    public BigDecimal getBigDecimal() {
        throw this.prepareUnexpectedUsageException("BigDecimal");
    }

    @Override
    public Date getDate() {
        throw this.prepareUnexpectedUsageException("Date");
    }

    @Override
    public Date getDatetime() {
        throw this.prepareUnexpectedUsageException("Datetime");
    }

    @Override
    public LocalDate getLocalDate() {
        throw this.prepareUnexpectedUsageException("LocalDate");
    }

    @Override
    public LocalDateTime getLocalDateTime() {
        throw this.prepareUnexpectedUsageException("LocalDatetime");
    }
}

