/*
 * Decompiled with CFR 0.152.
 */
package org.smartparam.engine.matchers;

import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.smartparam.engine.core.type.ValueHolder;
import org.smartparam.engine.matchers.InvalidBetweenMatcherPatternException;
import org.smartparam.engine.matchers.RangeToken;
import org.smartparam.engine.matchers.TokenSeparator;

class BasicTokenSeparator
implements TokenSeparator {
    private final String[] separators;

    @Override
    public RangeToken separate(String pattern) {
        int separatorIndex = this.findSeparatorIndex(pattern);
        String lower = pattern.substring(0, separatorIndex).trim();
        String upper = pattern.substring(separatorIndex + 1).trim();
        return new RangeToken(lower, upper, pattern.charAt(separatorIndex));
    }

    private <T extends ValueHolder> int findSeparatorIndex(String pattern) {
        if (StringUtils.startsWithAny(pattern, SPECIAL_CHARACTERS)) {
            return StringUtils.indexOfAny((CharSequence)pattern, this.separators);
        }
        if (StringUtils.endsWithAny(pattern, SPECIAL_CHARACTERS)) {
            return StringUtils.lastIndexOfAny(pattern, this.separators);
        }
        for (String separator : this.separators) {
            double separatorCount = StringUtils.countMatches((CharSequence)pattern, separator);
            if (!this.isCharSeparatorInPattern(separatorCount)) continue;
            return StringUtils.ordinalIndexOf(pattern, String.valueOf(separator), this.separatorOrdinalNumber(separatorCount));
        }
        throw new InvalidBetweenMatcherPatternException("could not find any valid separator for pattern: " + pattern + " with separators " + Arrays.toString(this.separators));
    }

    private int separatorOrdinalNumber(double separatorCount) {
        return (int)Math.ceil(separatorCount / 2.0);
    }

    private boolean isCharSeparatorInPattern(double separatorCount) {
        return separatorCount % 2.0 == 1.0;
    }

    public BasicTokenSeparator(String[] separators) {
        this.separators = separators;
    }
}

