/*
 * Decompiled with CFR 0.152.
 */
package org.smartparam.engine.matchers;

import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.smartparam.engine.core.type.Type;
import org.smartparam.engine.core.type.ValueHolder;
import org.smartparam.engine.matchers.RangeToken;
import org.smartparam.engine.matchers.TokenSeparator;
import org.smartparam.engine.matchers.TokenSeparatorFactory;

public class BetweenMatcherTokenSeparator {
    private static final String[] DEFAULT_SEPARATORS = new String[]{":", "-"};
    private String[] separators = Arrays.copyOf(DEFAULT_SEPARATORS, DEFAULT_SEPARATORS.length);

    public <T extends ValueHolder> RangeToken separate(String pattern, Type<T> type) {
        if (StringUtils.isBlank(pattern)) {
            return new RangeToken("", "", this.getFirstSeparator());
        }
        if (!StringUtils.containsAny((CharSequence)pattern, this.separators)) {
            return new RangeToken(pattern.trim(), "", this.getFirstSeparator());
        }
        TokenSeparatorFactory tokenSeparatorFactory = new TokenSeparatorFactory(this.separators);
        TokenSeparator tokenSeparator = tokenSeparatorFactory.getTokenSeparator(type);
        return tokenSeparator.separate(pattern);
    }

    private char getFirstSeparator() {
        if (this.separators.length > 0) {
            return this.separators[0].charAt(0);
        }
        throw new IllegalStateException("Separators are not defined.");
    }

    final void setSeparators(String separators) {
        if (StringUtils.isNotEmpty(separators)) {
            this.separators = separators.split("");
        }
    }
}

