/*
 * Decompiled with CFR 0.152.
 */
package org.smartparam.engine.types.date;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeParseException;
import java.util.Calendar;
import java.util.Date;
import org.smartparam.engine.annotated.annotations.ParamType;
import org.smartparam.engine.core.type.Type;
import org.smartparam.engine.types.date.AbstractDateType;
import org.smartparam.engine.types.date.DateTimeFormatterPool;
import org.smartparam.engine.types.date.LocalDateHolder;
import org.smartparam.engine.types.date.LocalDateParserChain;
import org.smartparam.engine.util.EngineUtil;

@ParamType(value="localDate")
public class LocalDateType
extends AbstractDateType<LocalDate>
implements Type<LocalDateHolder> {
    private final LocalDateParserChain parserChain = LocalDateParserChain.build();

    @Override
    public String encode(LocalDateHolder holder) {
        return holder.getString();
    }

    @Override
    public LocalDateHolder decode(String text) {
        LocalDate localDate = EngineUtil.hasText(text) ? (LocalDate)this.guess(text) : null;
        return new LocalDateHolder(localDate);
    }

    @Override
    public LocalDateHolder convert(Object obj) {
        if (obj instanceof LocalDate) {
            return new LocalDateHolder((LocalDate)obj);
        }
        if (obj instanceof LocalDateTime) {
            return new LocalDateHolder(((LocalDateTime)obj).toLocalDate());
        }
        if (obj instanceof Date) {
            return new LocalDateHolder(this.convertDateToLocalDate((Date)obj));
        }
        if (obj instanceof Calendar) {
            Calendar cal = (Calendar)obj;
            return new LocalDateHolder(this.convertDateToLocalDate(cal.getTime()));
        }
        if (obj == null) {
            return new LocalDateHolder(null);
        }
        if (obj instanceof String) {
            return this.decode((String)obj);
        }
        throw new IllegalArgumentException("conversion not supported for: " + obj.getClass());
    }

    private LocalDate convertDateToLocalDate(Date date) {
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public LocalDateHolder[] newArray(int size) {
        return new LocalDateHolder[size];
    }

    @Override
    protected LocalDate parse(String dateStr, String pattern) {
        try {
            return LocalDate.parse(dateStr, DateTimeFormatterPool.ofPattern(pattern));
        }
        catch (DateTimeParseException e) {
            return (LocalDate)this.parserChain.parse(dateStr);
        }
    }
}

