/*
 * Decompiled with CFR 0.152.
 */
package org.smartparam.engine.types.datetime;

import java.util.Date;
import pl.decerto.hyperon.runtime.utils.HprDate;

public abstract class AbstractDateTimeType<T> {
    private static String defaultOutputPattern = "yyyy-MM-dd HH:mm:ss.SSS";

    protected abstract T parseLong(String var1);

    protected abstract T of(long var1);

    protected T guess(String text) {
        String input = text.trim();
        if (this.isDigitsOnly(input)) {
            return this.parseLong(input);
        }
        String dateText = input;
        String timeText = "";
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (!Character.isWhitespace(c)) continue;
            dateText = input.substring(0, i).trim();
            timeText = input.substring(i, input.length()).trim();
            break;
        }
        Date date = HprDate.guess(dateText);
        int time = HprDate.parseTime(timeText);
        return this.of(date.getTime() + (long)time);
    }

    private boolean isDigitsOnly(String text) {
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    public static void setDefaultOutputPattern(String pattern) {
        defaultOutputPattern = pattern;
    }

    public static String getDefaultOutputPattern() {
        return defaultOutputPattern;
    }
}

