/*
 * Decompiled with CFR 0.152.
 */
package org.smartparam.engine.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.smartparam.engine.util.Formatter;
import org.smartparam.engine.util.Separator;

public final class Printer {
    private static final int MIN_OUTPUT_LINES = 3;
    private static final int EXPECTED_LINE_LENGTH = 32;
    private static final int LINE_NUMBER_WIDTH = 3;

    private Printer() {
        throw new UnsupportedOperationException();
    }

    public static String print(Collection<?> list, String title, int maxLines, Formatter formatter) {
        if (list == null) {
            return null;
        }
        int max = Math.max(maxLines, 3);
        int lines = Math.min(list.size(), maxLines);
        boolean printAll = maxLines == 0 || list.size() <= max;
        StringBuilder sb = new StringBuilder(lines * 32);
        sb.append(Separator.DEFAULT.getValue());
        if (title != null) {
            sb.append(title).append(" (").append(list.size()).append(')').append(Separator.DEFAULT.getValue());
        }
        int c = 0;
        for (Object e : list) {
            String value = Printer.format(e, formatter);
            if (printAll || ++c <= max - 2 || c == list.size()) {
                sb.append(Printer.padNumber(c)).append(". ").append(value);
                sb.append(Separator.DEFAULT.getValue());
                continue;
            }
            if (c != max - 1) continue;
            sb.append("  ...");
            sb.append(Separator.DEFAULT.getValue());
        }
        return sb.toString();
    }

    public static String print(Collection<?> list, String title) {
        return Printer.print(list, title, 0, null);
    }

    public static String print(Object[] array, String title) {
        List<Object> list = array != null ? Arrays.asList(array) : null;
        return Printer.print(list, title, 0, null);
    }

    static String format(Object e, Formatter formatter) {
        if (formatter != null) {
            return formatter.format(e);
        }
        if (e instanceof Object[]) {
            return Arrays.toString((Object[])e);
        }
        return String.valueOf(e);
    }

    private static String padNumber(int n) {
        String numberString = String.valueOf(n);
        if (3 > numberString.length()) {
            StringBuilder builder = new StringBuilder(3);
            for (int i = 0; i < 3 - numberString.length(); ++i) {
                builder.append(" ");
            }
            builder.append(numberString);
            return builder.toString();
        }
        return numberString;
    }
}

