/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.common.profiler;

import java.util.HashMap;
import java.util.Map;
import pl.decerto.hyperon.common.profiler.Profiler;

public abstract class ProfilerManager {
    public static final String GLOBAL_PROFILER_NAME = "GLOBAL_PROFILER";
    private static final Map<String, Profiler> PROFILERS = new HashMap<String, Profiler>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Profiler getProfiler(String name) {
        Profiler profiler = PROFILERS.get(name);
        if (profiler == null) {
            Map<String, Profiler> map = PROFILERS;
            synchronized (map) {
                profiler = PROFILERS.get(name);
                if (profiler == null) {
                    profiler = new Profiler(name);
                    PROFILERS.put(name, profiler);
                }
            }
        }
        return profiler;
    }

    public static void addOccurrence(String key, long time) {
        ProfilerManager.addOccurrence(GLOBAL_PROFILER_NAME, key, time);
    }

    public static void addOccurrence(String profilerName, String key, long time) {
        Profiler profiler = ProfilerManager.getProfiler(profilerName);
        profiler.addOccurrence(key, time);
    }

    public static Profiler.Monitor startProfile(String key) {
        return ProfilerManager.getProfiler(GLOBAL_PROFILER_NAME).startProfile(key);
    }

    public static Profiler.Monitor startProfile(String profilerName, String key) {
        return ProfilerManager.getProfiler(profilerName).startProfile(key);
    }

    public static void clear() {
        PROFILERS.clear();
    }

    public static void clear(String profilerName) {
        PROFILERS.remove(profilerName);
    }

    public static void clear(String profilerName, String key) {
        Profiler profiler = PROFILERS.get(profilerName);
        if (profiler != null) {
            profiler.clear(key);
        }
    }

    public static String print() {
        StringBuilder sb = new StringBuilder();
        sb.append("ProfilerManager").append("{GLOBAL_PROFILER_NAME=").append(GLOBAL_PROFILER_NAME).append('}');
        for (Map.Entry<String, Profiler> entry : PROFILERS.entrySet()) {
            sb.append("\n\n").append(entry.getKey());
        }
        return sb.toString();
    }

    public static String print(String profilerName) {
        Profiler profiler = PROFILERS.get(profilerName);
        if (profiler == null) {
            return profilerName + "=null";
        }
        return profiler.toString();
    }

    public static String print(String profilerName, String key) {
        Profiler profiler = PROFILERS.get(profilerName);
        if (profiler == null) {
            return profilerName + "=null";
        }
        Profiler.Entry entry = profiler.getEntry(key);
        if (entry == null) {
            return profilerName + "{" + key + "}=null";
        }
        return entry.toString();
    }
}

