/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.common.profiler.annotation;

import java.lang.reflect.Method;
import java.util.Objects;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import pl.decerto.hyperon.common.profiler.Profiler;
import pl.decerto.hyperon.common.profiler.ProfilerManager;
import pl.decerto.hyperon.common.profiler.annotation.Profiling;

@Aspect
@Component
public class ProfilingAspect {
    private static final Logger log = LoggerFactory.getLogger(ProfilingAspect.class);

    @Pointcut(value="@within(pl.decerto.hyperon.common.profiler.annotation.Profiling)")
    private void profilingClass() {
    }

    @Pointcut(value="@annotation(pl.decerto.hyperon.common.profiler.annotation.Profiling)")
    private void profilingMethod() {
    }

    @Pointcut(value="!@annotation(pl.decerto.hyperon.common.profiler.annotation.NoProfiling)")
    private void noSwitchOffProfiling() {
    }

    @Pointcut(value="within(pl.decerto.eagent.framework..*)")
    public void frameworkMethod() {
    }

    @Around(value="noSwitchOffProfiling() && (profilingClass() || profilingMethod())")
    public Object profiling(ProceedingJoinPoint pjp) throws Throwable {
        String key;
        Class<?> targetClass;
        Signature signature = pjp.getSignature();
        Profiling profilingAnnotation = this.getProfilingAnnotation(signature, targetClass = pjp.getTarget().getClass());
        if (Objects.isNull(profilingAnnotation)) {
            throw new IllegalStateException("no profiling annotation found");
        }
        String profiler = profilingAnnotation.profilerName();
        if ("".equals(profiler)) {
            profiler = targetClass.getSimpleName();
        }
        if ("".equals(key = profilingAnnotation.key())) {
            key = signature.getName();
        }
        try (Profiler.Monitor monitor = ProfilerManager.startProfile(profiler, key);){
            Object object = pjp.proceed();
            return object;
        }
    }

    private Profiling getProfilingAnnotation(Signature signature, Class<?> targetClass) {
        Method targetMethod;
        MethodSignature methodSignature = (MethodSignature)signature;
        Method method = methodSignature.getMethod();
        try {
            targetMethod = targetClass.getMethod(method.getName(), method.getParameterTypes());
        }
        catch (NoSuchMethodException e) {
            String msg = String.format("cannot find method %s at class %s", method.getName(), targetClass.getName());
            log.error(msg, e);
            throw new IllegalStateException(msg, e);
        }
        Profiling profilingAnnotation = targetMethod.getAnnotation(Profiling.class);
        if (profilingAnnotation == null) {
            profilingAnnotation = targetClass.getAnnotation(Profiling.class);
        }
        if (profilingAnnotation == null) {
            log.error("cannot find profiling annotation for method {} and class {}", (Object)method.getName(), (Object)targetClass.getName());
        }
        return profilingAnnotation;
    }
}

