/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.common.security;

import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;

public abstract class AbstractAuthorizationManager {
    private static final Logger log = LoggerFactory.getLogger(AbstractAuthorizationManager.class);

    public boolean authorize(Authentication authentication) {
        if (!this.isAuthenticated(authentication)) {
            return false;
        }
        return this.tryAuthorize(authentication);
    }

    protected abstract boolean tryAuthorize(Authentication var1);

    protected abstract boolean authenticationObjectTypeMatches(Authentication var1);

    private boolean isAuthenticated(Authentication authentication) {
        if (Objects.isNull(authentication)) {
            log.trace("Cannot authorize, authentication is null.");
            return false;
        }
        if (!this.authenticationObjectTypeMatches(authentication)) {
            log.trace("Cannot authorize, authentication is of not expected type {}.", (Object)authentication.getClass().getName());
            return false;
        }
        boolean authenticated = authentication.isAuthenticated();
        if (!authenticated) {
            log.trace("Cannot authorize, user is not authenticated");
            return false;
        }
        return true;
    }
}

