/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.common.security;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import pl.decerto.hyperon.common.security.SystemRightService;
import pl.decerto.hyperon.common.security.dao.SystemRightJPADao;
import pl.decerto.hyperon.common.security.dao.SystemRoleManagementDao;
import pl.decerto.hyperon.common.security.dao.UserManagementDao;
import pl.decerto.hyperon.common.security.domain.SystemRightJPA;
import pl.decerto.hyperon.common.security.domain.SystemRights;
import pl.decerto.hyperon.common.security.domain.SystemRoleJPA;
import pl.decerto.hyperon.common.security.dto.SystemRightDto;
import pl.decerto.hyperon.common.security.dto.SystemRole;
import pl.decerto.hyperon.common.security.mapper.SystemRightMapper;

@Service
public class SystemRightServiceImpl
implements SystemRightService {
    private static final Logger log = LoggerFactory.getLogger(SystemRightServiceImpl.class);
    private final SystemRightJPADao rightDao;
    private final SystemRoleManagementDao roleDao;
    private final UserManagementDao userDao;
    private final SystemRightMapper systemRightMapper;

    @Override
    @Transactional(readOnly=true)
    public List<SystemRightDto> getRights() {
        return this.systemRightMapper.toDto((List<SystemRightJPA>)this.rightDao.findAll());
    }

    @Override
    @Transactional(readOnly=true)
    public SystemRightDto getRight(String code) {
        return this.systemRightMapper.toDto(this.rightDao.getByCode(code));
    }

    @Override
    public void delete(Integer rightId) {
        this.rightDao.deleteById(rightId);
    }

    @Override
    @Transactional
    public void save(SystemRightDto systemRight, Set<SystemRole> primaryRole) {
        log.info("saving right {}", (Object)systemRight);
        SystemRightJPA savedRight = (SystemRightJPA)this.rightDao.save(this.systemRightMapper.toEntity(systemRight));
        this.processDeletedRoles(systemRight, primaryRole, savedRight);
        this.processUpdatedRoles(systemRight, savedRight);
        log.trace("right {} saved successfully", (Object)systemRight);
    }

    private void processUpdatedRoles(SystemRightDto dto, SystemRightJPA savedRight) {
        List<Integer> toUpdate = dto.getRoles().stream().map(SystemRole::getId).collect(Collectors.toList());
        Iterable rolesToUpdate = this.roleDao.findAllById(toUpdate);
        for (SystemRoleJPA systemRoleJPA : rolesToUpdate) {
            systemRoleJPA.addRight(savedRight);
        }
        log.info("adding right {} to roles {}", (Object)dto, (Object)SystemRoleJPA.getRolesCodes(rolesToUpdate));
        this.roleDao.saveAll(rolesToUpdate);
        if (!toUpdate.isEmpty()) {
            this.userDao.updateLastUpdateViaRoles(toUpdate);
        }
    }

    private void processDeletedRoles(SystemRightDto dto, Set<SystemRole> primaryRole, SystemRightJPA savedRight) {
        ArrayList<Integer> toDelete = new ArrayList<Integer>();
        for (SystemRole previous : primaryRole) {
            if (dto.getRoles().contains(previous)) continue;
            toDelete.add(previous.getId());
        }
        Iterable rolesToDelete = this.roleDao.findAllById(toDelete);
        for (SystemRoleJPA systemRoleJPA : rolesToDelete) {
            systemRoleJPA.getRights().remove(savedRight);
        }
        log.info("deleting right {} from roles {}", (Object)dto, (Object)SystemRoleJPA.getRolesCodes(rolesToDelete));
        this.roleDao.saveAll(rolesToDelete);
        if (!toDelete.isEmpty()) {
            this.userDao.updateLastUpdateViaRoles(toDelete);
        }
    }

    @Override
    public boolean isCodeUsed(String code, Integer idToSkip) {
        if (idToSkip == null) {
            return this.rightDao.countByCode(code) > 0L;
        }
        return this.rightDao.countByCodeWithoutOne(code, idToSkip) > 0L;
    }

    @Override
    @Transactional
    public void addTagAccessRights(String categoryName) {
        this.addRightIfNotExists(new SystemRightDto(SystemRights.PAR_R_CAT_ + categoryName), false);
        this.addRightIfNotExists(new SystemRightDto(SystemRights.PAR_W_CAT_ + categoryName), false);
    }

    @Override
    @Transactional
    public void changeTagAccessRights(String previousCode, String categoryName) {
        this.rightDao.updateCode(SystemRights.PAR_R_CAT_ + previousCode, SystemRights.PAR_R_CAT_ + categoryName);
        this.rightDao.updateCode(SystemRights.PAR_W_CAT_ + previousCode, SystemRights.PAR_W_CAT_ + categoryName);
    }

    @Override
    @Transactional
    public void deleteTagAccessRights(String previousCode) {
        this.deleteRightsForElement(SystemRights.PAR_R_CAT_ + previousCode, SystemRights.PAR_W_CAT_ + previousCode);
    }

    private void deleteRightsForElement(String previousCodeR, String previousCodeW) {
        SystemRightJPA rightR = this.rightDao.getByCode(previousCodeR);
        SystemRightJPA rightW = this.rightDao.getByCode(previousCodeW);
        if (rightR == null && rightW == null) {
            return;
        }
        if (rightR != null) {
            this.rightDao.delete(rightR);
        }
        if (rightW != null) {
            this.rightDao.delete(rightW);
        }
        for (SystemRoleJPA role : this.roleDao.findAll()) {
            if (rightR != null) {
                role.getRights().remove(rightR);
            }
            if (rightW == null) continue;
            role.getRights().remove(rightW);
        }
    }

    @Override
    public void importRight(SystemRightDto right) {
        this.addRightIfNotExists(right, true);
    }

    @Override
    public void changeProfileRights(String oldCode, String code) {
        this.rightDao.updateCode("PROD_R_" + oldCode, "PROD_R_" + code);
        this.rightDao.updateCode("PROD_W_" + oldCode, "PROD_W_" + code);
    }

    @Override
    public void addProfileRights(String code) {
        String rightCode = "PROD_R_" + code;
        this.addRightIfNotExists(new SystemRightDto(rightCode), false);
        rightCode = "PROD_W_" + code;
        this.addRightIfNotExists(new SystemRightDto(rightCode), false);
    }

    private void addRightIfNotExists(SystemRightDto right, boolean updateDescription) {
        String code = right.getCode();
        String description = right.getDescription();
        SystemRightJPA rightJpa = this.rightDao.getByCode(code);
        if (rightJpa == null) {
            this.rightDao.save(this.createRight(code, description));
        } else if (updateDescription && this.isDifferentDescription(description, rightJpa.getDescription())) {
            rightJpa.setDescription(description);
            this.rightDao.save(rightJpa);
        }
    }

    private SystemRightJPA createRight(String code, String description) {
        SystemRightJPA systemRight = new SystemRightJPA();
        systemRight.setCode(code);
        systemRight.setDescription(description);
        return systemRight;
    }

    private boolean isDifferentDescription(String description, String jpaDescription) {
        return !StringUtils.equals(description, jpaDescription);
    }

    @Override
    public void deleteProfileAccessRights(String code) {
        this.deleteRightsForElement("PROD_R_" + code, "PROD_W_" + code);
    }

    @Override
    public boolean isRightsForProfile(String code) {
        ArrayList<String> codes = new ArrayList<String>();
        codes.add("PROD_R_" + code);
        codes.add("PROD_W_" + code);
        return this.rightDao.countByCodes(codes) == 2L;
    }

    public SystemRightServiceImpl(SystemRightJPADao rightDao, SystemRoleManagementDao roleDao, UserManagementDao userDao, SystemRightMapper systemRightMapper) {
        this.rightDao = rightDao;
        this.roleDao = roleDao;
        this.userDao = userDao;
        this.systemRightMapper = systemRightMapper;
    }
}

