/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.common.security;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsPasswordService;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import pl.decerto.hyperon.common.security.MppUserDetails;
import pl.decerto.hyperon.common.security.dao.UserManagementDao;

@Component(value="userDetailsPasswordService")
public class SystemUserPasswordUpdater
implements UserDetailsPasswordService {
    private static final Logger log = LoggerFactory.getLogger(SystemUserPasswordUpdater.class);
    private final UserDetailsService userDetailsService;
    private final UserManagementDao userManagementDao;

    @Transactional
    public UserDetails updatePassword(UserDetails user, String newPassword) {
        this.userManagementDao.updatePassword(newPassword, ((MppUserDetails)user).getUser().getId());
        log.debug("Updated password algorithm for user: {}", (Object)user.getUsername());
        return this.userDetailsService.loadUserByUsername(user.getUsername());
    }

    public SystemUserPasswordUpdater(UserDetailsService userDetailsService, UserManagementDao userManagementDao) {
        this.userDetailsService = userDetailsService;
        this.userManagementDao = userManagementDao;
    }
}

