/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.common.security;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import pl.decerto.hyperon.common.security.MppUserDetails;
import pl.decerto.hyperon.common.security.domain.SystemRights;
import pl.decerto.hyperon.common.security.oauth2.HyperonOidcUserDetails;

public class UserRoleChecker {
    private static final Logger log = LoggerFactory.getLogger(UserRoleChecker.class);

    private UserRoleChecker() {
        throw new UnsupportedOperationException();
    }

    public static Authentication getAuthentication() {
        return SecurityContextHolder.getContext().getAuthentication();
    }

    public static boolean hasRight(SystemRights right) {
        return UserRoleChecker.hasRight(right.name());
    }

    public static boolean hasRight(String right) {
        return UserRoleChecker.currentUser().map(details -> details.hasRight(right)).orElse(false);
    }

    public static boolean hasAnyRights(List<SystemRights> rightsList) {
        if (Objects.isNull(rightsList)) {
            return false;
        }
        return UserRoleChecker.currentUser().map(details -> UserRoleChecker.hasAnyRights(rightsList, details)).orElse(false);
    }

    private static boolean hasAnyRights(List<SystemRights> rightsList, MppUserDetails details) {
        return rightsList.stream().anyMatch(r -> details.hasRight(r.name()));
    }

    public static boolean hasAnyParamReadRight() {
        return UserRoleChecker.checkRightOnCurrentUser(MppUserDetails::canReadAnyParam);
    }

    public static boolean hasAnyParamWriteRight() {
        return UserRoleChecker.checkRightOnCurrentUser(MppUserDetails::hasAnyParamWriteRight);
    }

    public static boolean hasHyperonStudioModificationRight() {
        return UserRoleChecker.checkRightOnCurrentUser(MppUserDetails::hasHyperonStudioModificationRight);
    }

    private static boolean checkRightOnCurrentUser(Predicate<MppUserDetails> supplier) {
        return UserRoleChecker.currentUser().map(supplier::test).orElse(false);
    }

    public static Optional<MppUserDetails> currentUser() {
        Authentication auth = UserRoleChecker.getAuthentication();
        if (auth == null || auth instanceof AnonymousAuthenticationToken) {
            log.trace("Cannot authorize, authentication is {}.", (Object)(auth == null ? "null" : auth.getClass().getName()));
            return Optional.empty();
        }
        Object principal = auth instanceof OAuth2AuthenticationToken ? ((HyperonOidcUserDetails)((OAuth2AuthenticationToken)auth).getPrincipal()).getHyperonUserDetails() : auth.getPrincipal();
        if (principal instanceof MppUserDetails) {
            return Optional.of((MppUserDetails)principal);
        }
        throw new IllegalStateException("Illegal authentication class: " + auth.getClass());
    }

    public static boolean hasParamWriteAndGuiEditionRights() {
        return UserRoleChecker.hasRight(SystemRights.PAR_W.name()) && UserRoleChecker.hasHyperonStudioModificationRight();
    }

    public static boolean hasAnyParamWriteAndGuiEditionRights() {
        return UserRoleChecker.hasAnyParamWriteRight() && UserRoleChecker.hasHyperonStudioModificationRight();
    }

    public static boolean hasTagWriteRight(String tagName) {
        return UserRoleChecker.hasRight(SystemRights.PAR_W_CAT_.name() + tagName);
    }
}

