/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.common.security;

import java.util.Comparator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import pl.decerto.hyperon.common.security.MppUserDetails;
import pl.decerto.hyperon.common.security.UserManagementService;
import pl.decerto.hyperon.common.security.UserRoleChecker;
import pl.decerto.hyperon.common.security.cache.UsersCacheManager;
import pl.decerto.hyperon.common.security.dto.SystemUser;

@Component
public class UserUtils {
    public static final Comparator<SystemUser> userLoginComparator = Comparator.comparing(SystemUser::getLogin);
    private UserManagementService userManagementService;
    private UsersCacheManager userCache;

    @Autowired
    public UserUtils(UserManagementService userManagementService, UsersCacheManager userCache) {
        this.userManagementService = userManagementService;
        this.userCache = userCache;
    }

    public void updateCurrentUserPreferredProfile(String profile2) {
        UserRoleChecker.currentUser().ifPresent(details -> this.updatePreferredProfile(profile2, (MppUserDetails)details));
    }

    private void updatePreferredProfile(String profile2, MppUserDetails details) {
        SystemUser user = this.userManagementService.modifyOrCreateSystemUserPreference(details.getUser(), "DOMAIN_PROFILE", profile2);
        details.refresh(user, this.userCache.getUserCacheEntry(user.getLogin()));
    }
}

