/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.common.security.cache;

import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import pl.decerto.hyperon.common.security.cache.UsersCacheManager;
import pl.decerto.hyperon.common.security.dao.UserJdbcDao;
import pl.decerto.hyperon.common.utils.lock.HyperonLockWrapper;
import pl.decerto.hyperon.runtime.utils.DateFormatUtils;

@Service
public class UserCacheWatcher {
    private static final Logger log = LoggerFactory.getLogger(UserCacheWatcher.class);
    private static final int INITIAL_DELAY_SEC = 10;
    private static final int FIXED_DELAY_SEC = 4;
    private static final int ERROR_RECOVERY_SEC = 30;
    private final UserJdbcDao cacheDao;
    private final UsersCacheManager cacheManager;
    private Date timestamp;
    private volatile boolean enabled;

    @Autowired
    public UserCacheWatcher(UserJdbcDao cacheDao, UsersCacheManager cacheManager) {
        this.cacheDao = cacheDao;
        this.cacheManager = cacheManager;
    }

    @Scheduled(initialDelay=10000L, fixedDelay=4000L)
    public void watch() {
        HyperonLockWrapper.executeWithLock(this::doWatch, this::handleException);
    }

    private void handleException(RuntimeException e) {
        log.error("user cache watcher failed but will retry", e);
        this.sleep();
        log.trace("user cache watcher reactivated after error pause");
    }

    public void start() {
        this.enabled = true;
        log.info("{} started...", (Object)this.getClass().getSimpleName());
    }

    public void stop() {
        this.enabled = false;
        log.info("{} stopped...", (Object)this.getClass().getSimpleName());
    }

    private void doWatch() {
        if (!this.enabled) {
            return;
        }
        log.trace("checking user cache accuracy");
        Date lastUpdate = this.cacheDao.getLastUpdate();
        log.trace("read last update: {}", (Object)lastUpdate);
        if (this.possibleModification(lastUpdate)) {
            this.invalidate();
            this.timestamp = lastUpdate;
            log.debug("last update set to: {}", (Object)this.printTimestamp());
        }
    }

    protected void invalidate() {
        this.cacheManager.invalidate();
    }

    private String printTimestamp() {
        return DateFormatUtils.formatDateTimeWithMillis(this.timestamp);
    }

    private boolean possibleModification(Date lastUpdate) {
        return lastUpdate != null && (this.timestamp == null || lastUpdate.getTime() > this.timestamp.getTime());
    }

    private void sleep() {
        try {
            Thread.sleep(30000L);
        }
        catch (InterruptedException e) {
            log.trace("user cache watcher sleep was interrupted", e);
            Thread.currentThread().interrupt();
        }
    }
}

