/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.common.security.configuration;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.crypto.password.PasswordEncoder;
import pl.decerto.hyperon.runtime.utils.hash.DigestAlgorithm;
import pl.decerto.hyperon.runtime.utils.hash.HashUtils;

public class MemoPasswordEncoder
implements PasswordEncoder {
    private static final Logger log = LoggerFactory.getLogger(MemoPasswordEncoder.class);
    final PasswordEncoder encoder;
    final Map<String, Boolean> memo = new ConcurrentHashMap<String, Boolean>();

    public String encode(CharSequence rawPassword) {
        return this.encoder.encode(rawPassword);
    }

    public boolean matches(CharSequence rawPassword, String encodedPassword) {
        String key = this.hash(rawPassword, encodedPassword);
        return this.memo.computeIfAbsent(key, k -> this.encoder.matches(rawPassword, encodedPassword));
    }

    public boolean upgradeEncoding(String encodedPassword) {
        return this.encoder.upgradeEncoding(encodedPassword);
    }

    private String hash(CharSequence raw, String encoded) {
        return HashUtils.hashText(DigestAlgorithm.SHA256, raw + encoded);
    }

    public MemoPasswordEncoder(PasswordEncoder encoder) {
        this.encoder = encoder;
    }
}

