/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.common.security.dao;

import java.util.Date;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.support.JdbcDaoSupport;
import org.springframework.stereotype.Component;
import pl.decerto.hyperon.common.profiler.Profiler;
import pl.decerto.hyperon.common.profiler.ProfilerManager;
import pl.decerto.hyperon.common.security.cache.UserCacheEntry;
import pl.decerto.hyperon.runtime.sql.DialectRegistry;
import pl.decerto.hyperon.runtime.sql.DialectTemplate;

@Component
public class UserJdbcDao
extends JdbcDaoSupport {
    private static final Logger log = LoggerFactory.getLogger(UserJdbcDao.class);
    private static final int MAX_LAST_UPDATE_QUERY_TIMEOUT_SECONDS = 8;
    private static final String USER_PROFILER_NAME = "userCache";
    private final DialectTemplate dialect = DialectRegistry.getDialectTemplate();

    @Autowired
    public UserJdbcDao(@Qualifier(value="dataSource") DataSource dataSource) {
        this.setDataSource(dataSource);
    }

    private JdbcTemplate jdbc() {
        return new JdbcTemplate(this.getDataSource());
    }

    public UserCacheEntry getUserRights(String login) {
        try (Profiler.Monitor monit = ProfilerManager.startProfile(USER_PROFILER_NAME, "getUserRights");){
            log.trace("enter getUserRights(login={})", (Object)login);
            String statement = "select us.id as userid, ri.$code as rightCode from @systemuserjpa us join @systemuserjpa_systemrolejpa us_ro on us_ro.users_id=us.id  join @systemrolejpa_systemrightjpa ro_ri on ro_ri.roles_id = us_ro.roles_id  join @systemrightjpa ri on ri.id = ro_ri.rights_id  where us.login=?";
            String sql = this.dialect.parse(statement);
            UserCacheEntry result = new UserCacheEntry();
            this.jdbc().query(sql, rs -> {
                result.setId(rs.getInt("userid"));
                result.addRight(rs.getString("rightCode"));
            }, new Object[]{login});
            UserCacheEntry userCacheEntry = result;
            return userCacheEntry;
        }
    }

    public Date getLastUpdate() {
        JdbcTemplate jdbcTemplate = this.getJdbcTemplate();
        try {
            Profiler.Monitor monit = ProfilerManager.startProfile(USER_PROFILER_NAME, "getLastUpdate");
            try {
                log.trace("enter getLastUpdate()");
                jdbcTemplate.setQueryTimeout(8);
                Date date = (Date)jdbcTemplate.queryForObject(this.dialect.parse("select max(lastupdate) from @systemuserjpa"), Date.class);
                if (monit != null) {
                    monit.close();
                }
                return date;
            }
            catch (Throwable throwable) {
                if (monit != null) {
                    try {
                        monit.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        finally {
            jdbcTemplate.setQueryTimeout(0);
        }
    }

    public void getUserPreferences(UserCacheEntry dto) {
        dto.clearPreferences();
        try (Profiler.Monitor monit = ProfilerManager.startProfile(USER_PROFILER_NAME, "getUserPreferences");){
            log.trace("enter getUserPreferences(dto={})", (Object)dto);
            String sql = this.dialect.parse("select usp.$key_name, usp.$value from @systemuserpreferencejpa usp where usp.user_id=?");
            this.jdbc().query(sql, (rs, i) -> {
                String value = this.dialect.getString(rs, "value");
                String key = this.dialect.getString(rs, "key_name");
                if (value != null) {
                    dto.addPreference(key, value);
                }
                return null;
            }, new Object[]{dto.getId()});
        }
    }
}

