/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.common.security.domain;

import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.SequenceGenerator;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.NotEmpty;
import pl.decerto.hyperon.common.persistence.jpa.BaseEntity;
import pl.decerto.hyperon.common.security.domain.PasswordStatus;
import pl.decerto.hyperon.common.security.domain.SystemRoleJPA;
import pl.decerto.hyperon.common.security.domain.SystemUserPreferenceJPA;
import pl.decerto.hyperon.common.security.domain.UserStatus;

@Entity
public class SystemUserJPA
extends BaseEntity {
    @Id
    @SequenceGenerator(name="systemuserjpa_id_generator", sequenceName="SEQ_SYSTEM_USER_JPA")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="systemuserjpa_id_generator")
    private int id;
    @Column(unique=true)
    @NotEmpty
    private String login;
    private String password;
    @Column(name="PASSWORD_STATUS")
    @Enumerated(value=EnumType.STRING)
    private PasswordStatus passwordStatus;
    @NotEmpty
    private String firstName;
    @NotEmpty
    private String lastName;
    @Column(unique=true)
    private String email;
    @NotNull
    private Date createDate;
    @NotNull
    private Date lastUpdate;
    @Enumerated(value=EnumType.STRING)
    private UserStatus status;
    @ManyToMany(fetch=FetchType.LAZY)
    private Set<SystemRoleJPA> roles = new HashSet<SystemRoleJPA>();
    @OneToMany(mappedBy="user", fetch=FetchType.LAZY)
    private Set<SystemUserPreferenceJPA> preferences = new HashSet<SystemUserPreferenceJPA>();

    @PreUpdate
    @PrePersist
    public void onUpdate() {
        this.lastUpdate = new Date();
        this.passwordStatus = Objects.isNull((Object)this.passwordStatus) ? PasswordStatus.SET : this.passwordStatus;
    }

    public void addRole(SystemRoleJPA role) {
        this.roles.add(role);
    }

    public void addPreference(SystemUserPreferenceJPA preference) {
        this.preferences.add(preference);
    }

    public String toString() {
        return "SystemUserJPA [ id=" + this.id + ", login=" + this.login + ", firstName=" + this.firstName + ", lastName=" + this.lastName + ", createDate=" + this.createDate + ", status=" + this.status + "]";
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setPasswordStatus(PasswordStatus passwordStatus) {
        this.passwordStatus = passwordStatus;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setCreateDate(@NotNull Date createDate) {
        this.createDate = createDate;
    }

    public void setStatus(UserStatus status) {
        this.status = status;
    }

    public void setRoles(Set<SystemRoleJPA> roles) {
        this.roles = roles;
    }

    public void setPreferences(Set<SystemUserPreferenceJPA> preferences) {
        this.preferences = preferences;
    }

    @Override
    public int getId() {
        return this.id;
    }

    public String getLogin() {
        return this.login;
    }

    public String getPassword() {
        return this.password;
    }

    public PasswordStatus getPasswordStatus() {
        return this.passwordStatus;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getEmail() {
        return this.email;
    }

    @NotNull
    public Date getCreateDate() {
        return this.createDate;
    }

    public UserStatus getStatus() {
        return this.status;
    }

    public Set<SystemRoleJPA> getRoles() {
        return this.roles;
    }

    public Set<SystemUserPreferenceJPA> getPreferences() {
        return this.preferences;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SystemUserJPA)) {
            return false;
        }
        SystemUserJPA other = (SystemUserJPA)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        String this$login = this.getLogin();
        String other$login = other.getLogin();
        if (this$login == null ? other$login != null : !this$login.equals(other$login)) {
            return false;
        }
        PasswordStatus this$passwordStatus = this.getPasswordStatus();
        PasswordStatus other$passwordStatus = other.getPasswordStatus();
        if (this$passwordStatus == null ? other$passwordStatus != null : !((Object)((Object)this$passwordStatus)).equals((Object)other$passwordStatus)) {
            return false;
        }
        String this$firstName = this.getFirstName();
        String other$firstName = other.getFirstName();
        if (this$firstName == null ? other$firstName != null : !this$firstName.equals(other$firstName)) {
            return false;
        }
        String this$lastName = this.getLastName();
        String other$lastName = other.getLastName();
        if (this$lastName == null ? other$lastName != null : !this$lastName.equals(other$lastName)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        UserStatus this$status = this.getStatus();
        UserStatus other$status = other.getStatus();
        return !(this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SystemUserJPA;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getId();
        String $login = this.getLogin();
        result = result * 59 + ($login == null ? 43 : $login.hashCode());
        PasswordStatus $passwordStatus = this.getPasswordStatus();
        result = result * 59 + ($passwordStatus == null ? 43 : ((Object)((Object)$passwordStatus)).hashCode());
        String $firstName = this.getFirstName();
        result = result * 59 + ($firstName == null ? 43 : $firstName.hashCode());
        String $lastName = this.getLastName();
        result = result * 59 + ($lastName == null ? 43 : $lastName.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        UserStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        return result;
    }
}

