/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.common.security.mapper;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import pl.decerto.hyperon.common.security.domain.JwtToken;
import pl.decerto.hyperon.common.security.dto.JwtTokenDto;
import pl.decerto.hyperon.common.security.mapper.JwtTokenMapper;
import pl.decerto.hyperon.common.security.mapper.SystemUserMapper;

@Component
public class JwtTokenMapperImpl
implements JwtTokenMapper {
    @Autowired
    private SystemUserMapper systemUserMapper;

    @Override
    public JwtToken toModel(JwtTokenDto dto) {
        if (dto == null) {
            return null;
        }
        JwtToken jwtToken = new JwtToken();
        if (dto.getId() != null) {
            jwtToken.setId(dto.getId());
        }
        jwtToken.setToken(dto.getToken());
        jwtToken.setCreateDate(dto.getCreateDate());
        jwtToken.setExpirationDate(dto.getExpirationDate());
        jwtToken.setTokenType(dto.getTokenType());
        jwtToken.setUser(this.systemUserMapper.toModel(dto.getUser()));
        return jwtToken;
    }

    @Override
    public JwtTokenDto toDto(JwtToken model) {
        if (model == null) {
            return null;
        }
        JwtTokenDto jwtTokenDto = new JwtTokenDto();
        jwtTokenDto.setId(model.getId());
        jwtTokenDto.setToken(model.getToken());
        jwtTokenDto.setCreateDate(model.getCreateDate());
        jwtTokenDto.setExpirationDate(model.getExpirationDate());
        jwtTokenDto.setUser(this.systemUserMapper.toDto(model.getUser()));
        jwtTokenDto.setTokenType(model.getTokenType());
        return jwtTokenDto;
    }
}

