/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.common.security.mapper;

import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import pl.decerto.hyperon.common.security.domain.SystemRightJPA;
import pl.decerto.hyperon.common.security.domain.SystemRoleJPA;
import pl.decerto.hyperon.common.security.domain.SystemUserJPA;
import pl.decerto.hyperon.common.security.dto.SystemRightDto;
import pl.decerto.hyperon.common.security.dto.SystemRole;
import pl.decerto.hyperon.common.security.dto.SystemUser;
import pl.decerto.hyperon.common.security.mapper.SystemRightMapper;
import pl.decerto.hyperon.common.security.mapper.SystemRoleFullMapper;
import pl.decerto.hyperon.common.security.mapper.SystemUserMapper;

@Component
public class SystemRoleFullMapperImpl
implements SystemRoleFullMapper {
    @Autowired
    private SystemUserMapper systemUserMapper;
    @Autowired
    private SystemRightMapper systemRightMapper;

    @Override
    public SystemRole toDto(SystemRoleJPA model) {
        if (model == null) {
            return null;
        }
        SystemRole systemRole = new SystemRole();
        systemRole.setId(model.getId());
        systemRole.setCode(model.getCode());
        systemRole.setDescription(model.getDescription());
        systemRole.setCreateDate(model.getCreateDate());
        systemRole.setUsers(this.systemUserJPASetToSystemUserSet(model.getUsers()));
        systemRole.setRights(this.systemRightJPASetToSystemRightDtoSet(model.getRights()));
        return systemRole;
    }

    @Override
    public SystemRoleJPA toModel(SystemRole role) {
        if (role == null) {
            return null;
        }
        SystemRoleJPA systemRoleJPA = new SystemRoleJPA();
        systemRoleJPA.setId(role.getId());
        systemRoleJPA.setCode(role.getCode());
        systemRoleJPA.setDescription(role.getDescription());
        systemRoleJPA.setCreateDate(role.getCreateDate());
        systemRoleJPA.setUsers(this.systemUserSetToSystemUserJPASet(role.getUsers()));
        systemRoleJPA.setRights(this.systemRightDtoSetToSystemRightJPASet(role.getRights()));
        return systemRoleJPA;
    }

    protected Set<SystemUser> systemUserJPASetToSystemUserSet(Set<SystemUserJPA> set) {
        if (set == null) {
            return null;
        }
        HashSet<SystemUser> set1 = new HashSet<SystemUser>(Math.max((int)((float)set.size() / 0.75f) + 1, 16));
        for (SystemUserJPA systemUserJPA : set) {
            set1.add(this.systemUserMapper.toDto(systemUserJPA));
        }
        return set1;
    }

    protected Set<SystemRightDto> systemRightJPASetToSystemRightDtoSet(Set<SystemRightJPA> set) {
        if (set == null) {
            return null;
        }
        HashSet<SystemRightDto> set1 = new HashSet<SystemRightDto>(Math.max((int)((float)set.size() / 0.75f) + 1, 16));
        for (SystemRightJPA systemRightJPA : set) {
            set1.add(this.systemRightMapper.toDto(systemRightJPA));
        }
        return set1;
    }

    protected Set<SystemUserJPA> systemUserSetToSystemUserJPASet(Set<SystemUser> set) {
        if (set == null) {
            return null;
        }
        HashSet<SystemUserJPA> set1 = new HashSet<SystemUserJPA>(Math.max((int)((float)set.size() / 0.75f) + 1, 16));
        for (SystemUser systemUser : set) {
            set1.add(this.systemUserMapper.toModel(systemUser));
        }
        return set1;
    }

    protected Set<SystemRightJPA> systemRightDtoSetToSystemRightJPASet(Set<SystemRightDto> set) {
        if (set == null) {
            return null;
        }
        HashSet<SystemRightJPA> set1 = new HashSet<SystemRightJPA>(Math.max((int)((float)set.size() / 0.75f) + 1, 16));
        for (SystemRightDto systemRightDto : set) {
            set1.add(this.systemRightMapper.toEntity(systemRightDto));
        }
        return set1;
    }
}

