/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.common.security.mapper;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import pl.decerto.hyperon.common.security.domain.SystemRoleJPA;
import pl.decerto.hyperon.common.security.domain.SystemUserJPA;
import pl.decerto.hyperon.common.security.domain.SystemUserPreferenceJPA;
import pl.decerto.hyperon.common.security.dto.SystemRole;
import pl.decerto.hyperon.common.security.dto.SystemUser;
import pl.decerto.hyperon.common.security.dto.SystemUserPreference;
import pl.decerto.hyperon.common.security.mapper.SystemRoleMapper;
import pl.decerto.hyperon.common.security.mapper.SystemUserFullMapper;
import pl.decerto.hyperon.common.security.mapper.SystemUserPreferenceMapper;

@Component
public class SystemUserFullMapperImpl
implements SystemUserFullMapper {
    @Autowired
    private SystemRoleMapper systemRoleMapper;
    @Autowired
    private SystemUserPreferenceMapper systemUserPreferenceMapper;

    @Override
    public SystemUser toDto(SystemUserJPA model) {
        if (model == null) {
            return null;
        }
        SystemUser systemUser = new SystemUser();
        systemUser.setPassword(model.getPassword());
        systemUser.setEmail(model.getEmail());
        systemUser.setId(model.getId());
        systemUser.setLogin(model.getLogin());
        systemUser.setPasswordStatus(model.getPasswordStatus());
        systemUser.setFirstName(model.getFirstName());
        systemUser.setLastName(model.getLastName());
        systemUser.setStatus(model.getStatus());
        systemUser.setRoles(this.systemRoleJPASetToSystemRoleSet(model.getRoles()));
        systemUser.setPreferences(this.systemUserPreferenceJPASetToSystemUserPreferenceSet(model.getPreferences()));
        systemUser.setCreateDate(new Date(model.getCreateDate().getTime()));
        return systemUser;
    }

    @Override
    public SystemUserJPA toModel(SystemUser dto) {
        if (dto == null) {
            return null;
        }
        SystemUserJPA systemUserJPA = new SystemUserJPA();
        systemUserJPA.setId(dto.getId());
        systemUserJPA.setLogin(dto.getLogin());
        systemUserJPA.setPassword(dto.getPassword());
        systemUserJPA.setPasswordStatus(dto.getPasswordStatus());
        systemUserJPA.setFirstName(dto.getFirstName());
        systemUserJPA.setLastName(dto.getLastName());
        systemUserJPA.setEmail(dto.getEmail());
        systemUserJPA.setCreateDate(dto.getCreateDate());
        systemUserJPA.setStatus(dto.getStatus());
        systemUserJPA.setRoles(this.systemRoleSetToSystemRoleJPASet(dto.getRoles()));
        systemUserJPA.setPreferences(this.systemUserPreferenceSetToSystemUserPreferenceJPASet(dto.getPreferences()));
        return systemUserJPA;
    }

    @Override
    public List<SystemUserJPA> toModel(List<SystemUser> dto) {
        if (dto == null) {
            return null;
        }
        ArrayList<SystemUserJPA> list = new ArrayList<SystemUserJPA>(dto.size());
        for (SystemUser systemUser : dto) {
            list.add(this.toModel(systemUser));
        }
        return list;
    }

    protected Set<SystemRole> systemRoleJPASetToSystemRoleSet(Set<SystemRoleJPA> set) {
        if (set == null) {
            return null;
        }
        HashSet<SystemRole> set1 = new HashSet<SystemRole>(Math.max((int)((float)set.size() / 0.75f) + 1, 16));
        for (SystemRoleJPA systemRoleJPA : set) {
            set1.add(this.systemRoleMapper.toDto(systemRoleJPA));
        }
        return set1;
    }

    protected Set<SystemUserPreference> systemUserPreferenceJPASetToSystemUserPreferenceSet(Set<SystemUserPreferenceJPA> set) {
        if (set == null) {
            return null;
        }
        HashSet<SystemUserPreference> set1 = new HashSet<SystemUserPreference>(Math.max((int)((float)set.size() / 0.75f) + 1, 16));
        for (SystemUserPreferenceJPA systemUserPreferenceJPA : set) {
            set1.add(this.systemUserPreferenceMapper.toDto(systemUserPreferenceJPA));
        }
        return set1;
    }

    protected Set<SystemRoleJPA> systemRoleSetToSystemRoleJPASet(Set<SystemRole> set) {
        if (set == null) {
            return null;
        }
        HashSet<SystemRoleJPA> set1 = new HashSet<SystemRoleJPA>(Math.max((int)((float)set.size() / 0.75f) + 1, 16));
        for (SystemRole systemRole : set) {
            set1.add(this.systemRoleMapper.toModel(systemRole));
        }
        return set1;
    }

    protected Set<SystemUserPreferenceJPA> systemUserPreferenceSetToSystemUserPreferenceJPASet(Set<SystemUserPreference> set) {
        if (set == null) {
            return null;
        }
        HashSet<SystemUserPreferenceJPA> set1 = new HashSet<SystemUserPreferenceJPA>(Math.max((int)((float)set.size() / 0.75f) + 1, 16));
        for (SystemUserPreference systemUserPreference : set) {
            set1.add(this.systemUserPreferenceMapper.toModel(systemUserPreference));
        }
        return set1;
    }
}

