/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.common.security.oauth2;

import org.springframework.boot.context.properties.ConfigurationPropertiesScan;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtDecoders;
import pl.decerto.hyperon.common.security.oauth2.HyperonSecurityOAuth2Properties;
import pl.decerto.hyperon.common.security.oauth2.OAuth2PropertyCondition;

@Configuration
@OAuth2PropertyCondition
@ConfigurationPropertiesScan
public class JwtTokenDecoderProvider {
    private final HyperonSecurityOAuth2Properties properties;

    @Bean
    public JwtDecoder jwtDecoder() {
        HyperonSecurityOAuth2Properties.Client client = this.properties.getClients().get(0);
        return JwtDecoders.fromIssuerLocation((String)client.getIssuer());
    }

    public JwtTokenDecoderProvider(HyperonSecurityOAuth2Properties properties) {
        this.properties = properties;
    }
}

