/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.common.utils;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Messages {
    private static final Logger log = LoggerFactory.getLogger(Messages.class);
    private static final String BUNDLE_NAME = "pl.decerto.hyperon.common.messages";
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("pl.decerto.hyperon.common.messages");

    private Messages() {
        throw new IllegalStateException();
    }

    private static String getMessageFromBundle(String key, ResourceBundle bundle) {
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            log.error("", e);
            return "!" + key + "!";
        }
    }

    public static String message(String key, Object ... params) {
        try {
            return MessageFormat.format(RESOURCE_BUNDLE.getString(key), params);
        }
        catch (MissingResourceException e) {
            log.error("", e);
            return "!" + key + "!";
        }
    }

    public static String message(String key) {
        return Messages.getMessageFromBundle(key, RESOURCE_BUNDLE);
    }
}

