/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.common.utils.database;

import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.naming.PhysicalNamingStrategy;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.decerto.hyperon.runtime.sql.DialectRegistry;
import pl.decerto.hyperon.runtime.sql.HyperonDialect;

public class HyperonPhysicalNamingStrategy
implements PhysicalNamingStrategy {
    private static final Logger log = LoggerFactory.getLogger(HyperonPhysicalNamingStrategy.class);

    public Identifier toPhysicalCatalogName(Identifier name, JdbcEnvironment jdbcEnvironment) {
        return name;
    }

    public Identifier toPhysicalSchemaName(Identifier name, JdbcEnvironment jdbcEnvironment) {
        return name;
    }

    public Identifier toPhysicalTableName(Identifier name, JdbcEnvironment jdbcEnvironment) {
        String table = name.getText();
        String alias = this.dialect().table(table);
        if (!alias.equals(table)) {
            log.info("dialect: modified table name [{}] -> [{}]", (Object)table, (Object)alias);
            return Identifier.toIdentifier((String)alias, (boolean)name.isQuoted());
        }
        return name;
    }

    public Identifier toPhysicalSequenceName(Identifier name, JdbcEnvironment jdbcEnvironment) {
        return name;
    }

    public Identifier toPhysicalColumnName(Identifier name, JdbcEnvironment jdbcEnvironment) {
        String column = name.getText();
        String alias = this.dialect().column(column);
        if (!alias.equals(column)) {
            log.info("dialect: modified column name [{}] -> [{}]", (Object)column, (Object)alias);
            return Identifier.toIdentifier((String)alias, (boolean)name.isQuoted());
        }
        return name;
    }

    private HyperonDialect dialect() {
        return DialectRegistry.getDialect();
    }
}

