/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.common.utils.resources;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import pl.decerto.hyperon.common.utils.resources.AbstractTypedResourceBundle;

public class TypedResourceBundle<T>
extends AbstractTypedResourceBundle<T> {
    private final Map<String, T> props;

    public TypedResourceBundle() {
        this.props = Collections.emptyMap();
    }

    public TypedResourceBundle(Map<String, T> content) {
        this.props = Collections.unmodifiableMap(content);
    }

    @Override
    protected T handleGetObject(String key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return this.props.get(key);
    }

    @Override
    protected Set<String> handleKeySet() {
        return this.props.keySet();
    }

    public Map<String, T> getMap() {
        return this.props;
    }

    public static abstract class TypedControl<T>
    extends AbstractTypedResourceBundle.AbstractTypedControl<T, TypedResourceBundle<T>> {
        public TypedControl(List<String> formats) {
            super(formats);
        }

        @Override
        protected final TypedResourceBundle<T> readBundle(BufferedInputStream inputStream, String format) throws IOException, IllegalAccessException, InstantiationException {
            Map<String, T> propertiesMap = this.readMap(inputStream);
            return new TypedResourceBundle<T>(propertiesMap);
        }

        protected abstract Map<String, T> readMap(BufferedInputStream var1) throws IOException, IllegalAccessException, InstantiationException;
    }
}

