/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.core;

import java.time.Duration;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.sql.DataSource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smartparam.engine.cache.MapFunctionCache;
import org.smartparam.engine.cache.MapPreparedParamCache;
import org.smartparam.engine.config.ParamEngineConfig;
import org.smartparam.engine.config.ParamEngineConfigBuilder;
import org.smartparam.engine.config.ParamEngineFactory;
import org.smartparam.engine.core.ParamEngine;
import org.smartparam.engine.core.SmartParamEngine;
import org.smartparam.engine.core.function.FunctionCache;
import org.smartparam.engine.core.prepared.PreparedParamCache;
import org.smartparam.engine.ext.FunctionInvokerInterceptor;
import org.smartparam.engine.matchers.BetweenMatcher;
import org.smartparam.engine.types.date.DateType;
import org.smartparam.engine.types.date.LocalDateType;
import org.smartparam.engine.types.datetime.DatetimeType;
import org.smartparam.engine.types.datetime.LocalDateTimeType;
import org.smartparam.engine.types.number.NumberType;
import org.smartparam.engine.types.string.StringType;
import org.smartparam.engine.util.Printer;
import pl.decerto.hyperon.runtime.cache.ProfileCache;
import pl.decerto.hyperon.runtime.cache.ProfileProvider;
import pl.decerto.hyperon.runtime.cache.UserRegionVersionCache;
import pl.decerto.hyperon.runtime.cache.UserRegionVersionProvider;
import pl.decerto.hyperon.runtime.constants.FunctionCode;
import pl.decerto.hyperon.runtime.core.HyperonContext;
import pl.decerto.hyperon.runtime.core.HyperonEngine;
import pl.decerto.hyperon.runtime.core.HyperonEngineImpl;
import pl.decerto.hyperon.runtime.core.Properties;
import pl.decerto.hyperon.runtime.core.StdFunctionInterceptor;
import pl.decerto.hyperon.runtime.core.domain.AttributeInterceptor;
import pl.decerto.hyperon.runtime.core.domain.AttributeValueProvider;
import pl.decerto.hyperon.runtime.core.domain.AttributeValueResolver;
import pl.decerto.hyperon.runtime.core.domain.DomainCache;
import pl.decerto.hyperon.runtime.core.domain.DomainCacheManager;
import pl.decerto.hyperon.runtime.core.domain.MpDomainCache;
import pl.decerto.hyperon.runtime.core.domain.MpDomainCacheManager;
import pl.decerto.hyperon.runtime.core.domain.MpDomainCacheProvider;
import pl.decerto.hyperon.runtime.core.domain.MpDomainRefreshController;
import pl.decerto.hyperon.runtime.core.domain.MpUserSessionProvider;
import pl.decerto.hyperon.runtime.core.domain.WatcherDomainCacheManager;
import pl.decerto.hyperon.runtime.core.extdatasource.ExternalDataSourceProvider;
import pl.decerto.hyperon.runtime.core.factory.EffectiveVersionFactory;
import pl.decerto.hyperon.runtime.core.factory.SystemVersionFactory;
import pl.decerto.hyperon.runtime.core.versioninterceptor.DeveloperModeInterceptor;
import pl.decerto.hyperon.runtime.core.versioninterceptor.EffectiveVersionResolver;
import pl.decerto.hyperon.runtime.core.versioninterceptor.RuntimeVersionInterceptor;
import pl.decerto.hyperon.runtime.core.versioninterceptor.VersionInterceptor;
import pl.decerto.hyperon.runtime.dao.DevModeJdbcDao;
import pl.decerto.hyperon.runtime.dao.DomainCacheJdbcDao;
import pl.decerto.hyperon.runtime.dao.FunctionJdbcDao;
import pl.decerto.hyperon.runtime.dao.SessionJdbcDao;
import pl.decerto.hyperon.runtime.dao.VersionJdbcDao;
import pl.decerto.hyperon.runtime.dao.external.ExternalStorageDao;
import pl.decerto.hyperon.runtime.dao.parameter.ParameterJdbcDao;
import pl.decerto.hyperon.runtime.dao.util.ConnectionInterceptor;
import pl.decerto.hyperon.runtime.dao.util.StdConnectionInterceptor;
import pl.decerto.hyperon.runtime.decoder.MpDecodingStrategy;
import pl.decerto.hyperon.runtime.dev.DevModePerspective;
import pl.decerto.hyperon.runtime.dev.DevModeProvider;
import pl.decerto.hyperon.runtime.dev.DevModeUserProvider;
import pl.decerto.hyperon.runtime.evict.DefaultIdleChecker;
import pl.decerto.hyperon.runtime.evict.IdleChecker;
import pl.decerto.hyperon.runtime.exception.HyperonRuntimeException;
import pl.decerto.hyperon.runtime.function.FunctionInvocationInterceptor;
import pl.decerto.hyperon.runtime.function.argument.FunctionArgumentDataTypeValidator;
import pl.decerto.hyperon.runtime.function.log.FunctionLogLevelCache;
import pl.decerto.hyperon.runtime.function.log.FunctionLoggerCreator;
import pl.decerto.hyperon.runtime.function.log.LogListener;
import pl.decerto.hyperon.runtime.invoker.GroovyFunctionInvoker;
import pl.decerto.hyperon.runtime.invoker.PropFunctionInvoker;
import pl.decerto.hyperon.runtime.invoker.PythonFunctionInvoker;
import pl.decerto.hyperon.runtime.invoker.RhinoFunctionInvoker;
import pl.decerto.hyperon.runtime.level.OutputLevelArraySeparator;
import pl.decerto.hyperon.runtime.matcher.ContainsAllMatcher;
import pl.decerto.hyperon.runtime.matcher.ContainsAnyMatcher;
import pl.decerto.hyperon.runtime.matcher.ContainsNoneMatcher;
import pl.decerto.hyperon.runtime.matcher.InMatcher;
import pl.decerto.hyperon.runtime.matcher.LikeMatcher;
import pl.decerto.hyperon.runtime.matcher.NotInMatcher;
import pl.decerto.hyperon.runtime.matcher.RegexMatcher;
import pl.decerto.hyperon.runtime.prefetch.FunctionInitializerImpl;
import pl.decerto.hyperon.runtime.prefetch.Initializer;
import pl.decerto.hyperon.runtime.prefetch.ParamInitializerImpl;
import pl.decerto.hyperon.runtime.prefetch.ParametersByRegionsPrefetchStrategy;
import pl.decerto.hyperon.runtime.prefetch.PrefetchStrategyAsyncExecutor;
import pl.decerto.hyperon.runtime.prefetch.SimplePrefetchStrategy;
import pl.decerto.hyperon.runtime.provider.MpFunctionProvider;
import pl.decerto.hyperon.runtime.provider.MpParameterProvider;
import pl.decerto.hyperon.runtime.provider.MpPropFunctionProvider;
import pl.decerto.hyperon.runtime.provider.MpScheduleProvider;
import pl.decerto.hyperon.runtime.provider.external.ExtSqlExecutor;
import pl.decerto.hyperon.runtime.reload.AsyncReloader;
import pl.decerto.hyperon.runtime.reload.DefaultReloader;
import pl.decerto.hyperon.runtime.reload.NoneReloadPolicy;
import pl.decerto.hyperon.runtime.reload.NopReloader;
import pl.decerto.hyperon.runtime.reload.ReloadPolicy;
import pl.decerto.hyperon.runtime.reload.Reloader;
import pl.decerto.hyperon.runtime.rhino.RhinoDate;
import pl.decerto.hyperon.runtime.rhino.RhinoDomain;
import pl.decerto.hyperon.runtime.rhino.RhinoHyperon;
import pl.decerto.hyperon.runtime.rhino.RhinoMath;
import pl.decerto.hyperon.runtime.rhino.RhinoStr;
import pl.decerto.hyperon.runtime.rhino.RhinoType;
import pl.decerto.hyperon.runtime.rhino.RhinoUtil;
import pl.decerto.hyperon.runtime.sql.DialectRegistry;
import pl.decerto.hyperon.runtime.sync.BaseWatcher;
import pl.decerto.hyperon.runtime.sync.DevModeWatcher;
import pl.decerto.hyperon.runtime.sync.DomainRuntimeWatcher;
import pl.decerto.hyperon.runtime.sync.DomainWatcherConfig;
import pl.decerto.hyperon.runtime.sync.FunctionRuntimeWatcher;
import pl.decerto.hyperon.runtime.sync.ParamRuntimeWatcher;
import pl.decerto.hyperon.runtime.sync.ProfileRuntimeWatcher;
import pl.decerto.hyperon.runtime.sync.RefreshRuntimeWatcher;
import pl.decerto.hyperon.runtime.sync.ScheduleRuntimeWatcher;
import pl.decerto.hyperon.runtime.sync.UserRegionVersionRuntimeWatcher;
import pl.decerto.hyperon.runtime.sync.VersionRuntimeWatcher;
import pl.decerto.hyperon.runtime.sync.WatcherConfig;
import pl.decerto.hyperon.runtime.sync.event.WatcherEventListener;
import pl.decerto.hyperon.runtime.type.BooleanType;
import pl.decerto.hyperon.runtime.type.IntegerType;
import pl.decerto.hyperon.runtime.type.TypesDto;
import pl.decerto.hyperon.runtime.version.system.SystemVersionCache;
import pl.decerto.hyperon.runtime.version.system.SystemVersionProvider;

public class HyperonEngineFactory {
    private static final Logger log = LoggerFactory.getLogger(HyperonEngineFactory.class);
    private static final int PROP_REPO_ORDER = 110;
    private static final int JAVA_REPO_ORDER = 120;
    private static final int WATCHER_DEFAULT_START_DELAY = 10;
    private static final int WATCHER_DEFAULT_PAUSE = 3;
    private static final int WATCHER_DEFAULT_RECOVERY = 30;
    private static final int SCHEDULE_WATCHER_PAUSE = 10;
    private static final int WATCHER_DOMAIN_DEFAULT_CACHE_LIFESPAN_VALUE = 24;
    private static final TemporalUnit WATCHER_DOMAIN_DEFAULT_CACHE_LIFESPAN_UNIT = DomainWatcherConfig.DEFAULT_LIFESPAN_IN_CACHE_UNIT;
    private DataSource dataSource;
    private String dialect;
    private boolean valueNeverNull = true;
    private boolean autoStartWatchers = true;
    private boolean enableDomainCache = true;
    private int maxConcurrentLoads = 3;
    @Deprecated
    private boolean refreshOnlyViaWatcher = true;
    private MpUserSessionProvider sessionProvider;
    private int watcherStartDelaySeconds = 10;
    private int watcherPauseSeconds = 3;
    private int watcherErrorPauseSeconds = 30;
    private int scheduleWatcherPauseSeconds = 10;
    private int domainWatcherInvalidateTime = 24;
    private TemporalUnit domainWatcherInvalidateTimeUnit = WATCHER_DOMAIN_DEFAULT_CACHE_LIFESPAN_UNIT;
    private WatcherConfig refreshWatcherConfig = new WatcherConfig(15, 10, 30);
    private WatcherConfig paramWatcherConfig = new WatcherConfig().delay(10).pause(3).error(30).force(60);
    private WatcherConfig functionWatcherConfig = new WatcherConfig().delay(10).pause(3).error(30);
    private ParameterJdbcDao paramDao;
    private FunctionJdbcDao functionDao;
    private ExternalStorageDao externalStorageDao;
    private VersionJdbcDao versionDao;
    private SessionJdbcDao sessionDao;
    private ConnectionInterceptor connectionInterceptor;
    private MpParameterProvider parameterProvider;
    private MpFunctionProvider functionProvider;
    private MpPropFunctionProvider propFunctionProvider;
    private PropFunctionInvoker propFunctionInvoker;
    private RhinoFunctionInvoker rhinoFunctionInvoker;
    private GroovyFunctionInvoker groovyFunctionInvoker;
    private PythonFunctionInvoker pythonFunctionInvoker;
    private MpDecodingStrategy decodingStrategy;
    private FunctionInvokerInterceptor levelCreatorInterceptor;
    private boolean groovySecured;
    private boolean supportedPython;
    private List<String> sharedModules;
    private DomainRuntimeWatcher domainRuntimeWatcher;
    private MpDomainCacheProvider domainCacheProvider;
    private DomainCacheJdbcDao domainCacheJdbcDao;
    private DomainCacheManager domainCacheManager;
    private DomainCache domainCache;
    private ProfileCache profileCache;
    private ProfileProvider profileProvider;
    private UserRegionVersionCache userRegionVersionCache;
    private UserRegionVersionProvider userRegionVersionProvider;
    private ParamRuntimeWatcher paramRuntimeWatcher;
    private PreparedParamCache preparedParamCache;
    private FunctionRuntimeWatcher functionRuntimeWatcher;
    private FunctionCache functionCache;
    private VersionRuntimeWatcher versionRuntimeWatcher;
    private ProfileRuntimeWatcher profileRuntimeWatcher;
    private UserRegionVersionRuntimeWatcher userRegionVersionRuntimeWatcher;
    private VersionInterceptor versionInterceptor;
    private EffectiveVersionResolver effectiveVersionResolver;
    private MpScheduleProvider scheduleProvider;
    private ScheduleRuntimeWatcher scheduleRuntimeWatcher;
    private RefreshRuntimeWatcher refreshRuntimeWatcher;
    private boolean developerMode;
    private String username;
    private DevModeProvider devModeProvider;
    private DevModeWatcher devModeWatcher;
    private boolean validateFunctionArgumentsDataTypes;
    private Map<String, Object> customPlugins;
    private List<String> paramsToPrefetch;
    private List<String> functionsToPrefetch;
    private Map<String, List<String>> profileToRegionsForParametersPrefetch = new HashMap<String, List<String>>();
    private AttributeInterceptor attributeInterceptor;
    private WatcherEventListener watcherEventListener;
    private List<FunctionInvocationInterceptor> functionInvocationInterceptors = new ArrayList<FunctionInvocationInterceptor>();
    private Duration functionLogLevelCacheTTL = FunctionLogLevelCache.DEFAULT_TTL;
    private ExternalDataSourceProvider externalDataSourceProvider;
    private ExtSqlExecutor extSqlExecutor;
    private String dbSchema;
    private OutputLevelArraySeparator outputLevelArraySeparator = OutputLevelArraySeparator.COMMA;
    private SystemVersionCache systemVersionCache;
    private SystemVersionProvider systemVersionProvider;
    private final Properties properties = new Properties();
    private final Collection<LogListener> logListeners = new ArrayList<LogListener>();
    private Initializer paramInitializerImpl;
    private Initializer functionInitializerImpl;
    private IdleChecker idleChecker = new DefaultIdleChecker(Duration.ofHours(16L));
    private ReloadPolicy reloadPolicy;
    private Reloader reloader;
    private AsyncReloader asyncReloader;

    public HyperonEngineFactory(DataSource dataSource, ConnectionInterceptor connectionInterceptor) {
        this.connectionInterceptor = connectionInterceptor;
        this.setDataSource(dataSource);
    }

    public HyperonEngineFactory(DataSource dataSource) {
        this.setDataSource(dataSource);
    }

    public final void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        this.decodingStrategy = new MpDecodingStrategy();
        this.externalDataSourceProvider = new ExternalDataSourceProvider();
        if (this.connectionInterceptor == null) {
            this.connectionInterceptor = new StdConnectionInterceptor();
        }
        this.extSqlExecutor = new ExtSqlExecutor(this.externalDataSourceProvider, this.connectionInterceptor);
        this.paramDao = new ParameterJdbcDao(dataSource, this.connectionInterceptor, this.decodingStrategy, this.extSqlExecutor);
        this.functionDao = new FunctionJdbcDao(dataSource, this.connectionInterceptor);
        this.externalStorageDao = new ExternalStorageDao(dataSource, this.connectionInterceptor);
        this.versionDao = new VersionJdbcDao(dataSource, this.connectionInterceptor);
        this.sessionDao = new SessionJdbcDao(dataSource, this.connectionInterceptor);
        SystemVersionFactory systemVersionFactory = new SystemVersionFactory(this.versionDao);
        this.systemVersionCache = systemVersionFactory.getSystemVersionCache();
        this.systemVersionProvider = systemVersionFactory.getSystemVersionProvider();
        this.domainCacheJdbcDao = new DomainCacheJdbcDao(dataSource, this.connectionInterceptor, this.versionDao, this.systemVersionProvider);
        this.scheduleProvider = new MpScheduleProvider(this.versionDao, this.paramDao, this.functionDao);
        EffectiveVersionFactory effectiveVersionFactory = new EffectiveVersionFactory(systemVersionFactory.getSystemVersionProvider(), this.scheduleProvider);
        this.effectiveVersionResolver = effectiveVersionFactory.getEffectiveVersionResolver();
        this.userRegionVersionCache = new UserRegionVersionCache();
        this.userRegionVersionProvider = new UserRegionVersionProvider(this.domainCacheJdbcDao, this.userRegionVersionCache);
    }

    public void setDialect(String dialect) {
        this.dialect = dialect;
    }

    public void setValueNeverNull(boolean valueNeverNull) {
        this.valueNeverNull = valueNeverNull;
    }

    public void setMaxConcurrentLoads(int maxConcurrentLoads) {
        this.maxConcurrentLoads = maxConcurrentLoads;
    }

    public void setSessionProvider(MpUserSessionProvider sessionProvider) {
        this.sessionProvider = sessionProvider;
        if (this.domainCache != null) {
            this.domainCache.setUserSessionProvider(sessionProvider);
        }
    }

    public void setAutoStartWatchers(boolean autoStartWatchers) {
        this.autoStartWatchers = autoStartWatchers;
    }

    public void setWatcherStartDelaySeconds(int watcherStartDelaySeconds) {
        this.watcherStartDelaySeconds = watcherStartDelaySeconds;
        this.paramWatcherConfig.delay(watcherStartDelaySeconds);
        this.functionWatcherConfig.delay(watcherStartDelaySeconds);
    }

    public void setWatcherPauseSeconds(int watcherPauseSeconds) {
        this.watcherPauseSeconds = watcherPauseSeconds;
        this.paramWatcherConfig.pause(watcherPauseSeconds);
        this.functionWatcherConfig.pause(watcherPauseSeconds);
    }

    public void setRefreshWatcherConfig(WatcherConfig conf) {
        this.refreshWatcherConfig = conf;
    }

    public void setDomainWatcherInvalidateCacheTime(int domainWatcherInvalidateCacheTime, TemporalUnit unit) {
        this.domainWatcherInvalidateTime = domainWatcherInvalidateCacheTime;
        this.domainWatcherInvalidateTimeUnit = unit;
    }

    public void setWatcherErrorPauseSeconds(int watcherErrorPauseSeconds) {
        this.watcherErrorPauseSeconds = watcherErrorPauseSeconds;
        this.paramWatcherConfig.error(watcherErrorPauseSeconds);
        this.functionWatcherConfig.error(watcherErrorPauseSeconds);
    }

    public void setWatcherForceSyncSeconds(int seconds) {
        this.paramWatcherConfig.force(seconds);
    }

    public void setScheduleWatcherPauseSeconds(int scheduleWatcherPauseSeconds) {
        this.scheduleWatcherPauseSeconds = scheduleWatcherPauseSeconds;
    }

    @Deprecated
    public void setRhinoPlugins(Map<String, Object> rhinoPlugins) {
        this.customPlugins = rhinoPlugins;
    }

    public void setCustomPlugins(Map<String, Object> customPlugins) {
        this.customPlugins = customPlugins;
    }

    public void setParamsToPrefetch(List<String> paramsToPrefetch) {
        this.paramsToPrefetch = paramsToPrefetch;
    }

    public void setFunctionsToPrefetch(List<String> functionsToPrefetch) {
        this.functionsToPrefetch = functionsToPrefetch;
    }

    public void addRegionForParametersPrefetch(String profileCode, String regionCode) {
        if (StringUtils.isBlank(profileCode)) {
            throw new IllegalArgumentException("profileCode should not be blank");
        }
        if (StringUtils.isBlank(regionCode)) {
            throw new IllegalArgumentException("regionCode should not be blank");
        }
        this.profileToRegionsForParametersPrefetch.computeIfAbsent(profileCode, key -> new ArrayList()).add(regionCode);
    }

    public HyperonEngineImpl create() {
        log.info("creating Higson Runtime component...");
        if (this.dataSource == null) {
            throw new HyperonRuntimeException("Illegal HyperonEngineFactory usage: no dataSource found");
        }
        this.setupDialectRegistry();
        if (this.externalDataSourceProvider.hasExternalDataSources()) {
            this.printExternalDataSources();
        }
        FunctionLogLevelCache logLevelCache = new FunctionLogLevelCache(this.functionLogLevelCacheTTL);
        FunctionLoggerCreator functionLoggerCreator = new FunctionLoggerCreator(this.logListeners, logLevelCache);
        this.propFunctionProvider = new MpPropFunctionProvider();
        this.propFunctionInvoker = new PropFunctionInvoker();
        this.rhinoFunctionInvoker = new RhinoFunctionInvoker(functionLoggerCreator);
        this.groovyFunctionInvoker = new GroovyFunctionInvoker(functionLoggerCreator, this.groovySecured);
        if (this.supportedPython) {
            this.pythonFunctionInvoker = this.createPythonFunctionInvoker(functionLoggerCreator);
        }
        this.preparedParamCache = new MapPreparedParamCache();
        this.functionCache = new MapFunctionCache();
        this.parameterProvider = new MpParameterProvider(this.paramDao, this.externalStorageDao, this.maxConcurrentLoads, this.externalDataSourceProvider, this.connectionInterceptor);
        this.functionProvider = new MpFunctionProvider(this.functionDao);
        this.profileCache = new ProfileCache();
        this.profileProvider = new ProfileProvider(this.profileCache, this.versionDao);
        this.versionInterceptor = new RuntimeVersionInterceptor(this.scheduleProvider, this.profileProvider);
        this.paramDao.setInterceptor(this.versionInterceptor);
        TypesDto typesDto = TypesDto.builder().stringType(new StringType()).numberType(new NumberType()).integerType(new IntegerType()).booleanType(new BooleanType()).dateType(new DateType()).datetimeType(new DatetimeType()).localDateType(new LocalDateType()).localDateTimeType(new LocalDateTimeType()).build();
        HyperonContext.initialize(typesDto);
        ParamEngineConfig conf = this.prepareEngineConfiguration();
        ParamEngine paramEngine = new ParamEngineFactory().createParamEngine(conf);
        log.debug("created core engine: {}", (Object)paramEngine);
        this.handleDeveloperMode();
        this.createDomainCache();
        log.debug("using value-never-null mode: {}", (Object)this.valueNeverNull);
        HyperonEngineImpl engine = new HyperonEngineImpl(paramEngine, this.domainCache, this.versionInterceptor, this.valueNeverNull);
        functionLoggerCreator.setHyperonEngine(engine);
        if (!this.decodingStrategy.hasEngineConfigured()) {
            this.decodingStrategy.setEngine(engine);
        }
        if (this.enableDomainCache) {
            log.debug("creating domain cache component...");
            this.setupDomainCacheComponent(this.domainCache, engine);
        }
        this.registerRhinoPlugins(engine);
        this.registerGroovyPlugins(engine);
        if (this.supportedPython) {
            this.registerPythonPlugins(engine);
        }
        if (this.levelCreatorInterceptor == null) {
            this.levelCreatorInterceptor = new StdFunctionInterceptor(engine);
        }
        if (paramEngine instanceof SmartParamEngine) {
            log.debug("installing function invocation interceptor");
            ((SmartParamEngine)paramEngine).setInvokerInterceptor(this.levelCreatorInterceptor);
        }
        this.createInitializers(engine);
        this.createReloader();
        if (this.autoStartWatchers) {
            WatcherConfig watcherConf = new WatcherConfig(this.watcherStartDelaySeconds, this.watcherPauseSeconds, this.watcherErrorPauseSeconds);
            log.debug("automatically starting runtime watchers...");
            this.startParamWatcher(this.paramWatcherConfig);
            this.startFunctionWatcher(this.functionWatcherConfig);
            DomainWatcherConfig domainWatcherConfig = new DomainWatcherConfig(this.watcherStartDelaySeconds, this.watcherPauseSeconds, this.watcherErrorPauseSeconds);
            domainWatcherConfig.invalidate(this.domainWatcherInvalidateTime, this.domainWatcherInvalidateTimeUnit);
            this.startDomainWatcher(domainWatcherConfig);
            this.startVersionWatcher(watcherConf);
            this.startProfileWatcher(watcherConf);
            this.startUserRegionVersionRuntimeWatcher(watcherConf);
            this.startScheduleWatcher();
            this.startRefreshWatcher(this.refreshWatcherConfig);
        }
        log.info("successfully created Higson Runtime component.");
        this.startPrefetchers(engine);
        return engine;
    }

    private PythonFunctionInvoker createPythonFunctionInvoker(FunctionLoggerCreator functionLoggerCreator) {
        if (CollectionUtils.isNotEmpty(this.sharedModules)) {
            return PythonFunctionInvoker.invokerWithExtraModules(this.sharedModules, functionLoggerCreator);
        }
        return PythonFunctionInvoker.defaultInvoker(functionLoggerCreator);
    }

    private ParamEngineConfig prepareEngineConfiguration() {
        ParamEngineConfigBuilder builder = ParamEngineConfigBuilder.paramEngineConfig().withAnnotationScanDisabled().withParameterRepositories(this.parameterProvider).withFunctionRepository("repo:prop", 110, this.propFunctionProvider).withFunctionRepository("repo:java", 120, this.functionProvider).withFunctionInvoker("prop", this.propFunctionInvoker).withFunctionInvoker("rhino", this.rhinoFunctionInvoker).withFunctionInvoker("groovy", this.groovyFunctionInvoker).withFunctionInvoker("python", this.pythonFunctionInvoker, this.supportedPython).withFunctionInvocationInterceptors(this.functionInvocationInterceptors).withParameterCache(this.preparedParamCache).withFunctionCache(this.functionCache).withType("number", HyperonContext.getNumberType()).withType("integer", HyperonContext.getIntegerType()).withType("string", HyperonContext.getStringType()).withType("boolean", HyperonContext.getBooleanType()).withType("date", HyperonContext.getDateType()).withType("datetime", HyperonContext.getDatetimeType()).withType("localDate", HyperonContext.getLocalDateType()).withType("localDateTime", HyperonContext.getLocalDateTimeType()).withMatcher("between/ie", new BetweenMatcher(true, false)).withMatcher("between/ei", new BetweenMatcher(false, true)).withMatcher("between/ii", new BetweenMatcher(true, true)).withMatcher("in", new InMatcher()).withMatcher("not-in", new NotInMatcher()).withMatcher("contains/any", new ContainsAnyMatcher()).withMatcher("contains/all", new ContainsAllMatcher()).withMatcher("contains/none", new ContainsNoneMatcher()).withMatcher("text/regex", new RegexMatcher()).withMatcher("text/like", new LikeMatcher()).withOutputLevelArraySeparator(this.outputLevelArraySeparator).withIdleChecker(this.idleChecker).withProperties(this.properties);
        log.info("using idle checker: {}", (Object)this.idleChecker);
        if (this.validateFunctionArgumentsDataTypes) {
            builder.withFunctionInvocationInterceptor(new FunctionArgumentDataTypeValidator());
        }
        return builder.build();
    }

    private void setupDialectRegistry() {
        if (DialectRegistry.getDialect() == null) {
            DialectRegistry.set(this.dialect != null ? this.dialect : DialectRegistry.DEFAULT_DIALECT);
        }
        if (StringUtils.isNotEmpty(this.dbSchema)) {
            DialectRegistry.setSchema(this.dbSchema);
        }
    }

    private void registerPythonPlugins(HyperonEngineImpl engine) {
        this.pythonFunctionInvoker.addGlobalObject(FunctionCode.HYPERON, new RhinoHyperon(engine));
    }

    private void registerGroovyPlugins(HyperonEngineImpl engine) {
        this.groovyFunctionInvoker.addGlobalObject(FunctionCode.STR, (Object)RhinoStr.INSTANCE);
        this.groovyFunctionInvoker.addGlobalObject(FunctionCode.UTIL, (Object)RhinoUtil.INSTANCE);
        this.groovyFunctionInvoker.addGlobalObject(FunctionCode.MATH, (Object)RhinoMath.INSTANCE);
        this.groovyFunctionInvoker.addGlobalObject(FunctionCode.DATE, (Object)RhinoDate.INSTANCE);
        this.groovyFunctionInvoker.addGlobalObject(FunctionCode.TYPE, (Object)new RhinoType());
        this.groovyFunctionInvoker.addGlobalObject(FunctionCode.MPP, (Object)new RhinoHyperon(engine));
        this.groovyFunctionInvoker.addGlobalObject(FunctionCode.HYPERON, (Object)new RhinoHyperon(engine));
        this.groovyFunctionInvoker.addGlobalObject(FunctionCode.HIGSON, (Object)new RhinoHyperon(engine));
        if (this.enableDomainCache) {
            this.groovyFunctionInvoker.addGlobalObject(FunctionCode.DOMAIN, (Object)new RhinoDomain(engine));
        }
        if (this.customPlugins != null) {
            for (Map.Entry<String, Object> entry : this.customPlugins.entrySet()) {
                this.groovyFunctionInvoker.addGlobalObject(entry.getKey(), entry.getValue());
            }
        }
    }

    private void handleDeveloperMode() {
        if (this.developerMode) {
            log.info("runtime mode: dev");
            log.info("devmode user: {}", (Object)this.username);
            this.setupDeveloperMode();
        } else {
            log.info("runtime mode: production");
        }
    }

    private void setupDeveloperMode() {
        DevModeJdbcDao dao = new DevModeJdbcDao(this.dataSource, this.connectionInterceptor);
        this.devModeProvider = new DevModeProvider(dao, this.scheduleProvider);
        RuntimeVersionInterceptor runtimeVersionInterceptor = new RuntimeVersionInterceptor(this.scheduleProvider, this.profileProvider);
        DevModePerspective devModePerspective = new DevModePerspective(this.devModeProvider, runtimeVersionInterceptor);
        this.versionInterceptor = new DeveloperModeInterceptor(runtimeVersionInterceptor, devModePerspective, this.username);
        this.sessionProvider = new DevModeUserProvider(this.username);
        this.paramDao.setInterceptor(this.versionInterceptor);
        this.devModeWatcher = new DevModeWatcher(this.devModeProvider);
        this.devModeWatcher.setConfig(new WatcherConfig(this.watcherStartDelaySeconds, 1, this.watcherErrorPauseSeconds));
        if (this.autoStartWatchers) {
            this.devModeWatcher.start();
        }
    }

    private void createDomainCache() {
        if (this.domainCache == null) {
            this.domainCache = new MpDomainCache();
        }
    }

    private void setupDomainCacheComponent(DomainCache domain, HyperonEngineImpl engine) {
        if (this.attributeInterceptor != null) {
            log.info("using domain attribute interceptor: {}", (Object)this.attributeInterceptor);
        }
        AttributeValueResolver resolver = new AttributeValueResolver(engine);
        AttributeValueProvider provider = new AttributeValueProvider(resolver, this.attributeInterceptor);
        if (this.domainCacheManager == null) {
            this.domainCacheProvider = new MpDomainCacheProvider(this.domainCacheJdbcDao, this.effectiveVersionResolver, this.userRegionVersionProvider, provider);
            this.domainCacheManager = new MpDomainCacheManager(this.domainCacheProvider, this.effectiveVersionResolver, new MpDomainRefreshController(this.domainCacheJdbcDao));
        } else {
            this.domainCacheProvider.setAttributeValueProvider(provider);
        }
        domain.setup(this.domainCacheManager);
        domain.setUserSessionProvider(this.sessionProvider);
        domain.setVersionJdbcDao(this.versionDao);
    }

    private void registerRhinoPlugins(HyperonEngineImpl engine) {
        this.rhinoFunctionInvoker.addGlobalObject(FunctionCode.STR, (Object)RhinoStr.INSTANCE);
        this.rhinoFunctionInvoker.addGlobalObject(FunctionCode.UTIL, (Object)RhinoUtil.INSTANCE);
        this.rhinoFunctionInvoker.addGlobalObject(FunctionCode.MATH, (Object)RhinoMath.INSTANCE);
        this.rhinoFunctionInvoker.addGlobalObject(FunctionCode.DATE, (Object)RhinoDate.INSTANCE);
        this.rhinoFunctionInvoker.addGlobalObject(FunctionCode.TYPE, (Object)new RhinoType());
        this.rhinoFunctionInvoker.addGlobalObject(FunctionCode.MPP, (Object)new RhinoHyperon(engine));
        this.rhinoFunctionInvoker.addGlobalObject(FunctionCode.HYPERON, (Object)new RhinoHyperon(engine));
        this.rhinoFunctionInvoker.addGlobalObject(FunctionCode.HIGSON, (Object)new RhinoHyperon(engine));
        if (this.enableDomainCache) {
            this.rhinoFunctionInvoker.addGlobalObject(FunctionCode.DOMAIN, (Object)new RhinoDomain(engine));
        }
        if (this.customPlugins != null) {
            for (Map.Entry<String, Object> entry : this.customPlugins.entrySet()) {
                this.rhinoFunctionInvoker.addGlobalObject(entry.getKey(), entry.getValue());
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("rhino invoker initialized with such global objects: {}", (Object)Printer.print(this.rhinoFunctionInvoker.getGlobalObjects().entrySet(), "global variables"));
        }
    }

    private void printExternalDataSources() {
        log.info("default datasource: {}", (Object)this.dataSource);
        for (String code : this.externalDataSourceProvider.listExternalDataSources()) {
            DataSource ext = this.externalDataSourceProvider.getDataSource(code);
            log.info("external datasource: {} -> {}", (Object)code, (Object)ext);
        }
    }

    public ParamRuntimeWatcher startParamWatcher(WatcherConfig config) {
        this.paramRuntimeWatcher = new ParamRuntimeWatcher(this.parameterProvider, this.preparedParamCache, this.devModeProvider, this.sessionDao, this.reloader);
        this.paramRuntimeWatcher.setConfig(config);
        this.paramRuntimeWatcher.setEventListener(this.watcherEventListener);
        this.paramRuntimeWatcher.start();
        return this.paramRuntimeWatcher;
    }

    public FunctionRuntimeWatcher startFunctionWatcher(WatcherConfig config) {
        this.functionRuntimeWatcher = new FunctionRuntimeWatcher(this.functionProvider, this.functionCache, this.groovyFunctionInvoker, this.functionInitializerImpl);
        this.functionRuntimeWatcher.setConfig(config);
        this.functionRuntimeWatcher.setEventListener(this.watcherEventListener);
        this.functionRuntimeWatcher.start();
        return this.functionRuntimeWatcher;
    }

    public VersionRuntimeWatcher startVersionWatcher(WatcherConfig config) {
        this.versionRuntimeWatcher = this.createVersionWatcher(config);
        this.versionRuntimeWatcher.start();
        return this.versionRuntimeWatcher;
    }

    public VersionRuntimeWatcher createVersionWatcher(WatcherConfig config) {
        this.versionRuntimeWatcher = new VersionRuntimeWatcher(this.versionDao, this.functionCache, this.preparedParamCache, this.systemVersionCache, this.userRegionVersionCache);
        this.versionRuntimeWatcher.setConfig(config);
        return this.versionRuntimeWatcher;
    }

    private ProfileRuntimeWatcher startProfileWatcher(WatcherConfig config) {
        this.profileRuntimeWatcher = new ProfileRuntimeWatcher(this.versionDao, this.profileCache);
        this.profileRuntimeWatcher.setConfig(config);
        this.profileRuntimeWatcher.start();
        return this.profileRuntimeWatcher;
    }

    private UserRegionVersionRuntimeWatcher startUserRegionVersionRuntimeWatcher(WatcherConfig config) {
        this.userRegionVersionRuntimeWatcher = this.createUserRegionVersionWatcher(config);
        this.userRegionVersionRuntimeWatcher.start();
        return this.userRegionVersionRuntimeWatcher;
    }

    public UserRegionVersionRuntimeWatcher createUserRegionVersionWatcher(WatcherConfig config) {
        UserRegionVersionRuntimeWatcher watcher = new UserRegionVersionRuntimeWatcher(this.versionDao, this.userRegionVersionCache);
        watcher.setConfig(config);
        return watcher;
    }

    public ScheduleRuntimeWatcher startScheduleWatcher() {
        this.scheduleRuntimeWatcher = new ScheduleRuntimeWatcher(this.scheduleProvider);
        this.scheduleRuntimeWatcher.setConfig(new WatcherConfig(this.scheduleWatcherPauseSeconds));
        this.scheduleRuntimeWatcher.start();
        return this.scheduleRuntimeWatcher;
    }

    public RefreshRuntimeWatcher startRefreshWatcher(WatcherConfig config) {
        this.refreshRuntimeWatcher = new RefreshRuntimeWatcher(this.preparedParamCache);
        this.refreshRuntimeWatcher.setConfig(config);
        this.refreshRuntimeWatcher.start();
        return this.refreshRuntimeWatcher;
    }

    public DomainRuntimeWatcher startDomainWatcher(WatcherConfig watcherConf) {
        if (this.enableDomainCache) {
            this.domainRuntimeWatcher = new DomainRuntimeWatcher((WatcherDomainCacheManager)this.domainCacheManager);
            this.domainRuntimeWatcher.setConfig(watcherConf);
            this.domainRuntimeWatcher.start();
        }
        return this.domainRuntimeWatcher;
    }

    private void startPrefetchers(HyperonEngine engine) {
        if (CollectionUtils.isNotEmpty(this.paramsToPrefetch)) {
            this.startParameterPrefetch(engine);
        }
        if (CollectionUtils.isNotEmpty(this.functionsToPrefetch)) {
            this.startFunctionPrefetch(engine);
        }
        if (!this.profileToRegionsForParametersPrefetch.isEmpty()) {
            this.startParametersByRegionsPrefetch(engine);
        }
    }

    private void createInitializers(HyperonEngine engine) {
        this.paramInitializerImpl = new ParamInitializerImpl(engine);
        this.functionInitializerImpl = new FunctionInitializerImpl(engine, this.functionDao);
    }

    private void createReloader() {
        if (this.reloadPolicy == null) {
            this.reloadPolicy = new NoneReloadPolicy();
            this.reloader = new NopReloader();
        } else {
            this.asyncReloader = new AsyncReloader(this.paramInitializerImpl);
            this.reloader = new DefaultReloader(this.versionDao, this.paramDao, this.reloadPolicy, this.asyncReloader);
        }
        log.info("created param reloader: {}", (Object)this.reloader);
        log.info("using reloading policy: {}", (Object)this.reloadPolicy);
    }

    private void startParameterPrefetch(HyperonEngine engine) {
        log.debug("startParameterPrefetch, starting to process parameters (async) ...");
        SimplePrefetchStrategy prefetchStrategy = new SimplePrefetchStrategy(this.paramInitializerImpl, this.paramsToPrefetch);
        PrefetchStrategyAsyncExecutor.execute(prefetchStrategy);
    }

    private void startParametersByRegionsPrefetch(HyperonEngine engine) {
        log.debug("startParametersByRegionsPrefetch, starting to process parameters (async) ...");
        ParamInitializerImpl initializer = new ParamInitializerImpl(engine);
        ParametersByRegionsPrefetchStrategy prefetchStrategy = new ParametersByRegionsPrefetchStrategy(initializer, this.paramDao, this.profileToRegionsForParametersPrefetch);
        PrefetchStrategyAsyncExecutor.execute(prefetchStrategy);
    }

    private void startFunctionPrefetch(HyperonEngine engine) {
        log.debug("starting to process functions (async) ...");
        SimplePrefetchStrategy prefetchStrategy = new SimplePrefetchStrategy(this.functionInitializerImpl, this.functionsToPrefetch);
        PrefetchStrategyAsyncExecutor.execute(prefetchStrategy);
    }

    public void destroy() {
        BaseWatcher[] watchers;
        log.info("closing higson-runtime components...");
        if (this.asyncReloader != null) {
            this.asyncReloader.close();
        }
        for (BaseWatcher watcher : watchers = new BaseWatcher[]{this.paramRuntimeWatcher, this.functionRuntimeWatcher, this.versionRuntimeWatcher, this.profileRuntimeWatcher, this.userRegionVersionRuntimeWatcher, this.scheduleRuntimeWatcher, this.domainRuntimeWatcher, this.devModeWatcher, this.refreshRuntimeWatcher}) {
            if (watcher == null) continue;
            watcher.stop();
        }
    }

    public void setLevelCreatorInterceptor(FunctionInvokerInterceptor levelCreatorInterceptor) {
        this.levelCreatorInterceptor = levelCreatorInterceptor;
    }

    public void setEnableDomainCache(boolean enableDomainCache) {
        this.enableDomainCache = enableDomainCache;
    }

    @Deprecated
    public void setRefreshOnlyViaWatcher(boolean refreshOnlyViaWatcher) {
        this.refreshOnlyViaWatcher = refreshOnlyViaWatcher;
    }

    public void setAttributeInterceptor(AttributeInterceptor attributeInterceptor) {
        this.attributeInterceptor = attributeInterceptor;
    }

    public void setWatcherEventListener(WatcherEventListener watcherEventListener) {
        this.watcherEventListener = watcherEventListener;
    }

    public boolean isDeveloperMode() {
        return this.developerMode;
    }

    public void setDeveloperMode(boolean developerMode) {
        this.developerMode = developerMode;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setValidateFunctionArgumentsDataTypes(boolean validateFunctionArgumentsDataTypes) {
        this.validateFunctionArgumentsDataTypes = validateFunctionArgumentsDataTypes;
    }

    @Deprecated
    public boolean isRefreshOnlyViaWatcher() {
        return this.refreshOnlyViaWatcher;
    }

    public Optional<PythonFunctionInvoker> getPythonFunctionInvoker() {
        return this.supportedPython ? Optional.of(this.pythonFunctionInvoker) : Optional.empty();
    }

    public void addExternalDataSources(Map<String, DataSource> dataSourceMap) {
        for (Map.Entry<String, DataSource> e : dataSourceMap.entrySet()) {
            this.addExternalDataSource(e.getKey(), e.getValue());
        }
    }

    public void addExternalDataSource(String code, DataSource dataSource) {
        this.externalDataSourceProvider.withExternalDataSource(code, dataSource);
    }

    public void setExternalDataSources(Map<String, DataSource> map) {
        for (Map.Entry<String, DataSource> e : map.entrySet()) {
            this.addExternalDataSource(e.getKey(), e.getValue());
        }
    }

    public void redefineDomainCache(DomainCache newMpDomainCache, MpDomainCacheProvider newDomainCacheProvider, DomainCacheManager newDomainCacheManager) {
        this.domainCache = newMpDomainCache;
        this.domainCacheProvider = newDomainCacheProvider;
        this.domainCacheManager = newDomainCacheManager;
    }

    public void setDbSchema(String dbSchema) {
        this.dbSchema = dbSchema;
    }

    public void setExternalModulesForPython(List<String> modules) {
        this.sharedModules = modules;
    }

    public void setThrowOnNormalizeInputValueException(boolean throwOnNormalizeInputValueException) {
        this.properties.setThrowOnNormalizeInputValueException(throwOnNormalizeInputValueException);
    }

    public void addFunctionInvocationInterceptor(FunctionInvocationInterceptor functionInvocationInterceptor) {
        this.functionInvocationInterceptors.add(functionInvocationInterceptor);
    }

    public void setFunctionLogLevelCacheTTL(Duration ttl) {
        this.functionLogLevelCacheTTL = ttl;
    }

    public void attachLogListener(LogListener logListener) {
        this.logListeners.add(logListener);
    }

    public void setIdleChecker(IdleChecker idleChecker) {
        this.idleChecker = idleChecker;
    }

    public void setMaxIdleTime(Duration maxIdleTime) {
        this.idleChecker = new DefaultIdleChecker(maxIdleTime.toMillis());
    }

    public void setReloadPolicy(ReloadPolicy reloadPolicy) {
        this.reloadPolicy = reloadPolicy;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public boolean isValueNeverNull() {
        return this.valueNeverNull;
    }

    public boolean isAutoStartWatchers() {
        return this.autoStartWatchers;
    }

    public boolean isEnableDomainCache() {
        return this.enableDomainCache;
    }

    public int getMaxConcurrentLoads() {
        return this.maxConcurrentLoads;
    }

    public int getWatcherStartDelaySeconds() {
        return this.watcherStartDelaySeconds;
    }

    public int getWatcherPauseSeconds() {
        return this.watcherPauseSeconds;
    }

    public int getWatcherErrorPauseSeconds() {
        return this.watcherErrorPauseSeconds;
    }

    public int getScheduleWatcherPauseSeconds() {
        return this.scheduleWatcherPauseSeconds;
    }

    public WatcherConfig getRefreshWatcherConfig() {
        return this.refreshWatcherConfig;
    }

    public WatcherConfig getParamWatcherConfig() {
        return this.paramWatcherConfig;
    }

    public WatcherConfig getFunctionWatcherConfig() {
        return this.functionWatcherConfig;
    }

    public ExternalStorageDao getExternalStorageDao() {
        return this.externalStorageDao;
    }

    public VersionJdbcDao getVersionDao() {
        return this.versionDao;
    }

    public SessionJdbcDao getSessionDao() {
        return this.sessionDao;
    }

    public MpParameterProvider getParameterProvider() {
        return this.parameterProvider;
    }

    public MpFunctionProvider getFunctionProvider() {
        return this.functionProvider;
    }

    public MpPropFunctionProvider getPropFunctionProvider() {
        return this.propFunctionProvider;
    }

    public PropFunctionInvoker getPropFunctionInvoker() {
        return this.propFunctionInvoker;
    }

    public RhinoFunctionInvoker getRhinoFunctionInvoker() {
        return this.rhinoFunctionInvoker;
    }

    public GroovyFunctionInvoker getGroovyFunctionInvoker() {
        return this.groovyFunctionInvoker;
    }

    public MpDecodingStrategy getDecodingStrategy() {
        return this.decodingStrategy;
    }

    public FunctionInvokerInterceptor getLevelCreatorInterceptor() {
        return this.levelCreatorInterceptor;
    }

    public DomainRuntimeWatcher getDomainRuntimeWatcher() {
        return this.domainRuntimeWatcher;
    }

    public MpDomainCacheProvider getDomainCacheProvider() {
        return this.domainCacheProvider;
    }

    public DomainCacheJdbcDao getDomainCacheJdbcDao() {
        return this.domainCacheJdbcDao;
    }

    public DomainCacheManager getDomainCacheManager() {
        return this.domainCacheManager;
    }

    public DomainCache getDomainCache() {
        return this.domainCache;
    }

    public ProfileProvider getProfileProvider() {
        return this.profileProvider;
    }

    public UserRegionVersionCache getUserRegionVersionCache() {
        return this.userRegionVersionCache;
    }

    public UserRegionVersionProvider getUserRegionVersionProvider() {
        return this.userRegionVersionProvider;
    }

    public ParamRuntimeWatcher getParamRuntimeWatcher() {
        return this.paramRuntimeWatcher;
    }

    public PreparedParamCache getPreparedParamCache() {
        return this.preparedParamCache;
    }

    public FunctionRuntimeWatcher getFunctionRuntimeWatcher() {
        return this.functionRuntimeWatcher;
    }

    public FunctionCache getFunctionCache() {
        return this.functionCache;
    }

    public VersionRuntimeWatcher getVersionRuntimeWatcher() {
        return this.versionRuntimeWatcher;
    }

    public ProfileRuntimeWatcher getProfileRuntimeWatcher() {
        return this.profileRuntimeWatcher;
    }

    public UserRegionVersionRuntimeWatcher getUserRegionVersionRuntimeWatcher() {
        return this.userRegionVersionRuntimeWatcher;
    }

    public VersionInterceptor getVersionInterceptor() {
        return this.versionInterceptor;
    }

    public EffectiveVersionResolver getEffectiveVersionResolver() {
        return this.effectiveVersionResolver;
    }

    public MpScheduleProvider getScheduleProvider() {
        return this.scheduleProvider;
    }

    public ScheduleRuntimeWatcher getScheduleRuntimeWatcher() {
        return this.scheduleRuntimeWatcher;
    }

    public RefreshRuntimeWatcher getRefreshRuntimeWatcher() {
        return this.refreshRuntimeWatcher;
    }

    public String getUsername() {
        return this.username;
    }

    public DevModeProvider getDevModeProvider() {
        return this.devModeProvider;
    }

    public DevModeWatcher getDevModeWatcher() {
        return this.devModeWatcher;
    }

    public List<String> getParamsToPrefetch() {
        return this.paramsToPrefetch;
    }

    public List<String> getFunctionsToPrefetch() {
        return this.functionsToPrefetch;
    }

    public AttributeInterceptor getAttributeInterceptor() {
        return this.attributeInterceptor;
    }

    public WatcherEventListener getWatcherEventListener() {
        return this.watcherEventListener;
    }

    public Duration getFunctionLogLevelCacheTTL() {
        return this.functionLogLevelCacheTTL;
    }

    public ExtSqlExecutor getExtSqlExecutor() {
        return this.extSqlExecutor;
    }

    public String getDbSchema() {
        return this.dbSchema;
    }

    public OutputLevelArraySeparator getOutputLevelArraySeparator() {
        return this.outputLevelArraySeparator;
    }

    public SystemVersionCache getSystemVersionCache() {
        return this.systemVersionCache;
    }

    public SystemVersionProvider getSystemVersionProvider() {
        return this.systemVersionProvider;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public Collection<LogListener> getLogListeners() {
        return this.logListeners;
    }

    public Initializer getParamInitializerImpl() {
        return this.paramInitializerImpl;
    }

    public Initializer getFunctionInitializerImpl() {
        return this.functionInitializerImpl;
    }

    public IdleChecker getIdleChecker() {
        return this.idleChecker;
    }

    public ReloadPolicy getReloadPolicy() {
        return this.reloadPolicy;
    }

    public Reloader getReloader() {
        return this.reloader;
    }

    public AsyncReloader getAsyncReloader() {
        return this.asyncReloader;
    }

    public HyperonEngineFactory() {
    }

    public void setGroovySecured(boolean groovySecured) {
        this.groovySecured = groovySecured;
    }

    public void setSupportedPython(boolean supportedPython) {
        this.supportedPython = supportedPython;
    }

    public void setOutputLevelArraySeparator(OutputLevelArraySeparator outputLevelArraySeparator) {
        this.outputLevelArraySeparator = outputLevelArraySeparator;
    }
}

