/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.invoker;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import jep.Interpreter;
import jep.JepConfig;
import jep.JepException;
import jep.SubInterpreter;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smartparam.engine.core.function.Function;
import org.smartparam.engine.core.function.FunctionInvoker;
import pl.decerto.hyperon.runtime.constants.FunctionCode;
import pl.decerto.hyperon.runtime.exception.HyperonRuntimeException;
import pl.decerto.hyperon.runtime.function.log.FunctionLoggerCreator;
import pl.decerto.hyperon.runtime.invoker.PythonPreprocessor;
import pl.decerto.hyperon.runtime.model.PythonFunction;
import pl.decerto.hyperon.runtime.profiler.engine.EngineProfiler;

public class PythonFunctionInvoker
implements FunctionInvoker {
    private static final Logger log = LoggerFactory.getLogger(PythonFunctionInvoker.class);
    private static final Map<FunctionCode, Object> GLOBAL_OBJECTS = new ConcurrentHashMap<FunctionCode, Object>();
    private static final PythonPreprocessor PREPROCESSOR = new PythonPreprocessor();
    private static final Map<String, Interpreter> INTERPRETER_POOL = new ConcurrentHashMap<String, Interpreter>();
    private static final JepConfig jepConfig = new JepConfig();
    private final Map<Integer, String> cacheForFunctions = new ConcurrentHashMap<Integer, String>();
    private final Map<CompiledPython, String> innerCompiledCache = new ConcurrentHashMap<CompiledPython, String>();
    private static final EngineProfiler profiler = EngineProfiler.FUNCTION;
    private final FunctionLoggerCreator functionLoggerCreator;

    private PythonFunctionInvoker(FunctionLoggerCreator functionLoggerCreator) {
        this.functionLoggerCreator = functionLoggerCreator;
    }

    public static PythonFunctionInvoker defaultInvoker(FunctionLoggerCreator functionLoggerCreator) {
        return new PythonFunctionInvoker(functionLoggerCreator);
    }

    public static PythonFunctionInvoker invokerWithExtraModules(List<String> module, FunctionLoggerCreator functionLoggerCreator) {
        module.forEach(xva$0 -> jepConfig.addSharedModules((String)xva$0));
        return new PythonFunctionInvoker(functionLoggerCreator);
    }

    @Override
    public Object invoke(Function function, Object ... args) {
        long t = System.currentTimeMillis();
        try {
            Object object = this.call((PythonFunction)function, args);
            return object;
        }
        catch (JepException e) {
            throw new HyperonRuntimeException("Python function invocation error", e);
        }
        finally {
            profiler.addGetMeasure(function.getName(), t, System.currentTimeMillis());
        }
    }

    public Object call(PythonFunction function, Object[] args) throws JepException {
        Interpreter interpreter = this.getInternalInterpreter(function);
        String preparedFunction = this.cacheForFunctions.computeIfAbsent(function.getImplId(), key -> PREPROCESSOR.apply(function));
        CompiledPython key2 = new CompiledPython(interpreter, function.getImplId());
        if (!this.innerCompiledCache.containsKey(key2)) {
            log.trace("Missing key, then adding new one");
            this.innerCompiledCache.put(key2, preparedFunction);
            interpreter.eval(preparedFunction);
            interpreter.eval(null);
        }
        log.trace("Invoking {}", (Object)function.getName());
        return interpreter.invoke(this.getNormalizedName(function), args);
    }

    private Interpreter getInternalInterpreter(PythonFunction function) {
        String threadName = Thread.currentThread().getName();
        INTERPRETER_POOL.computeIfAbsent(threadName, key -> this.init(function));
        return INTERPRETER_POOL.get(threadName);
    }

    public void invalidate(int implId) {
        this.cacheForFunctions.remove(implId);
        List interpretersWithThisFunction = this.innerCompiledCache.keySet().stream().filter(cc -> cc.functionImplementationId == implId).collect(Collectors.toList());
        this.innerCompiledCache.keySet().removeIf(interpretersWithThisFunction::contains);
    }

    private Interpreter init(PythonFunction function) {
        try {
            SubInterpreter interpreter = jepConfig.createSubInterpreter();
            this.prepareGlobalVariables(interpreter, function);
            return interpreter;
        }
        catch (JepException e) {
            throw new HyperonRuntimeException("Problem with Python Interpreter creation", e);
        }
    }

    private void prepareGlobalVariables(Interpreter interpreter, PythonFunction function) throws JepException {
        interpreter.set("hyperon", GLOBAL_OBJECTS.get((Object)FunctionCode.HYPERON));
        interpreter.set("higson", GLOBAL_OBJECTS.get((Object)FunctionCode.HIGSON));
        interpreter.set("log", this.functionLoggerCreator.createLogger(function));
    }

    public void addGlobalObject(FunctionCode code, Object obj) {
        GLOBAL_OBJECTS.put(code, obj);
    }

    private String getNormalizedName(PythonFunction pythonFunction) {
        return StringUtils.replaceChars(pythonFunction.getName(), '.', '_');
    }

    private static final class CompiledPython {
        private final Interpreter interpreter;
        private final int functionImplementationId;

        private CompiledPython(Interpreter interpreter, int functionImplementationId) {
            this.interpreter = interpreter;
            this.functionImplementationId = functionImplementationId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CompiledPython)) {
                return false;
            }
            CompiledPython other = (CompiledPython)o;
            if (this.functionImplementationId != other.functionImplementationId) {
                return false;
            }
            Interpreter this$interpreter = this.interpreter;
            Interpreter other$interpreter = other.interpreter;
            return !(this$interpreter == null ? other$interpreter != null : !this$interpreter.equals(other$interpreter));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.functionImplementationId;
            Interpreter $interpreter = this.interpreter;
            result = result * 59 + ($interpreter == null ? 43 : $interpreter.hashCode());
            return result;
        }
    }
}

