/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.invoker;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smartparam.engine.core.function.Function;
import org.smartparam.engine.core.function.FunctionInvoker;
import pl.decerto.hyperon.runtime.constants.FunctionCode;
import pl.decerto.hyperon.runtime.exception.HyperonRuntimeException;
import pl.decerto.hyperon.runtime.function.log.FunctionLoggerCreator;
import pl.decerto.hyperon.runtime.function.log.HyperonLogger;
import pl.decerto.hyperon.runtime.invoker.RhinoPreprocessor;
import pl.decerto.hyperon.runtime.model.RhinoFunction;
import pl.decerto.hyperon.runtime.profiler.engine.EngineProfiler;

public class RhinoFunctionInvoker
implements FunctionInvoker {
    private static final Logger log = LoggerFactory.getLogger(RhinoFunctionInvoker.class);
    private final Map<Integer, org.mozilla.javascript.Function> compileCache = new ConcurrentHashMap<Integer, org.mozilla.javascript.Function>();
    private final Map<String, Object> globalJavaObjects = new ConcurrentHashMap<String, Object>();
    private static final EngineProfiler profiler = EngineProfiler.FUNCTION;
    private final FunctionLoggerCreator functionLoggerCreator;
    private static final int INITIAL_EXTENT = 256;
    private static final int OPTIMIZATION_LEVEL = 9;

    public RhinoFunctionInvoker(FunctionLoggerCreator functionLoggerCreator) {
        this.functionLoggerCreator = functionLoggerCreator;
    }

    public RhinoFunctionInvoker() {
        this(new FunctionLoggerCreator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Function function, Object ... args) {
        long startTime = System.currentTimeMillis();
        try {
            Object object = this.call(this.cast(function), args);
            return object;
        }
        finally {
            profiler.addGetMeasure(function.getName(), startTime, System.currentTimeMillis());
        }
    }

    private RhinoFunction cast(Function function) {
        if (function instanceof RhinoFunction) {
            return (RhinoFunction)function;
        }
        log.error("Unexpected function: {}", (Object)function);
        throw new HyperonRuntimeException("Illegal function passed to RhinoFunctionInvoker: " + function);
    }

    public void invalidate(int functionId) {
        log.debug("invalidating cc for impl.id: {}", (Object)functionId);
        org.mozilla.javascript.Function f = this.compileCache.remove(functionId);
        if (f != null) {
            log.debug("found and invalidated: {}", (Object)f);
        } else {
            log.debug("impl not found in cc");
        }
    }

    public void invalidate() {
        log.debug("invalidating all compiled functions");
        this.compileCache.clear();
    }

    public void addGlobalObject(String code, Object obj) {
        this.globalJavaObjects.put(code, obj);
    }

    public void addGlobalObject(FunctionCode functionCode, Object obj) {
        this.globalJavaObjects.put(functionCode.code(), obj);
    }

    public Map<String, Object> getGlobalObjects() {
        return this.globalJavaObjects;
    }

    private Object call(RhinoFunction function, Object ... args) {
        try {
            org.mozilla.javascript.Function js = this.findCompiledFunction(function);
            return this.internalCall(js, args);
        }
        catch (RuntimeException e) {
            throw new HyperonRuntimeException("Rhino function invocation error", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object internalCall(org.mozilla.javascript.Function js, Object ... args) {
        Object result;
        Context ctx = Context.enter();
        try {
            Scriptable scope = js.getParentScope();
            result = js.call(ctx, scope, scope, args);
        }
        finally {
            Context.exit();
        }
        return this.unwrap(result);
    }

    private org.mozilla.javascript.Function findCompiledFunction(RhinoFunction function) {
        org.mozilla.javascript.Function js = this.compileCache.get(function.getImplId());
        if (js == null) {
            js = this.compile(function);
            this.compileCache.put(function.getImplId(), js);
        }
        return js;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private org.mozilla.javascript.Function compile(RhinoFunction function) {
        String fullBody = this.createFullBody(function);
        log.trace("compiling rhino function: \n{}", (Object)fullBody);
        Context ctx = Context.enter();
        ctx.setOptimizationLevel(9);
        try {
            Scriptable scope = this.initCompileScope(ctx, this.functionLoggerCreator.createLogger(function));
            org.mozilla.javascript.Function function2 = ctx.compileFunction(scope, fullBody, "", 0, null);
            return function2;
        }
        finally {
            Context.exit();
        }
    }

    private Scriptable initCompileScope(Context ctx, HyperonLogger functionLogger) {
        ScriptableObject scope = ctx.initStandardObjects();
        for (Map.Entry<String, Object> e : this.globalJavaObjects.entrySet()) {
            String variableName = e.getKey();
            Object variableObj = e.getValue();
            scope.put(variableName, (Scriptable)scope, Context.javaToJS(variableObj, scope));
        }
        scope.put(FunctionCode.LOG.code(), (Scriptable)scope, Context.javaToJS(functionLogger, scope));
        return scope;
    }

    String createFullBody(RhinoFunction function) {
        String body = new RhinoPreprocessor(function.getBody()).preprocess().get();
        StringBuilder functionBodyBuilder = new StringBuilder(body.length() + 256);
        functionBodyBuilder.append("function ").append(this.internalName(function));
        functionBodyBuilder.append('(');
        if (StringUtils.isNotBlank(function.getArgs())) {
            functionBodyBuilder.append(function.getArgs());
        }
        functionBodyBuilder.append(") {");
        functionBodyBuilder.append('\n');
        functionBodyBuilder.append(body);
        functionBodyBuilder.append('\n');
        this.appendStandardFunctions(functionBodyBuilder);
        functionBodyBuilder.append('}');
        return functionBodyBuilder.toString();
    }

    void appendStandardFunctions(StringBuilder functionBodyBuilder) {
        this.appendLine(functionBodyBuilder, "//#std::begin");
        this.appendStdFunction(functionBodyBuilder, "_integer", "type.getInteger");
        this.appendStdFunction(functionBodyBuilder, "_number", "type.getNumber");
        this.appendStdFunction(functionBodyBuilder, "_decimal", "type.getDecimal");
        this.appendStdFunction(functionBodyBuilder, "_date", "type.getDate");
        this.appendStdFunction(functionBodyBuilder, "_boolean", "type.getBoolean");
        this.appendStdFunction(functionBodyBuilder, "_string", "type.getString");
        this.appendStdFunction(functionBodyBuilder, "_int", "_integer");
        this.appendStdFunction(functionBodyBuilder, "_bool", "_boolean");
        this.appendStdFunction(functionBodyBuilder, "_str", "_string");
        this.appendStdFunction2arg(functionBodyBuilder, "_num", "type.getNumber");
        this.appendStdFunction2arg(functionBodyBuilder, "_dec", "type.getDecimal");
        this.appendLine(functionBodyBuilder, "//#std::end");
    }

    void appendStdFunction(StringBuilder sb, String f1, String f2) {
        this.appendLine(sb, String.format("function %s(x){return %s(x);}", f1, f2));
    }

    void appendStdFunction2arg(StringBuilder sb, String f1, String f2) {
        this.appendLine(sb, String.format("function %s(x,y){return y===undefined ? %s(x) : %s(x,y);}", f1, f2, f2));
    }

    void appendLine(StringBuilder sb, String line) {
        sb.append(line).append('\n');
    }

    String internalName(RhinoFunction function) {
        int id = function.getImplId();
        return (id < 0 ? "T_" : "F_") + Math.abs(id);
    }

    Object unwrap(Object result) {
        if (result instanceof NativeJavaObject) {
            return ((NativeJavaObject)result).unwrap();
        }
        if (result instanceof NativeArray) {
            NativeArray nativeArray = (NativeArray)result;
            Object[] array = new Object[(int)nativeArray.getLength()];
            for (Object ix : nativeArray.getIds()) {
                int index = (Integer)ix;
                array[index] = nativeArray.get(index, null);
            }
            return array;
        }
        if (result instanceof Undefined) {
            return null;
        }
        return result;
    }

    public synchronized void initContextFactory(ContextFactory factory) {
        if (!ContextFactory.hasExplicitGlobal()) {
            ContextFactory.initGlobal(factory);
            log.info("using rhino context factory: {}", (Object)factory);
        }
    }

    public Map<Integer, org.mozilla.javascript.Function> getCompileCacheSnapshot() {
        return new HashMap<Integer, org.mozilla.javascript.Function>(this.compileCache);
    }
}

