/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import pl.decerto.hyperon.runtime.dao.DomainCacheJdbcDao;
import pl.decerto.hyperon.runtime.model.DomainTokenResolver;
import pl.decerto.hyperon.runtime.model.HyperonDomainObject;
import pl.decerto.hyperon.runtime.model.HyperonDomainObjectImpl;
import pl.decerto.hyperon.runtime.model.HyperonDomainObjectType;
import pl.decerto.hyperon.runtime.model.HyperonDomainObjectTypeImpl;
import pl.decerto.hyperon.runtime.model.ReferenceDto;
import pl.decerto.hyperon.runtime.model.RegionCached;
import pl.decerto.hyperon.runtime.profiler.attribute.AttributeKey;
import pl.decerto.hyperon.runtime.profiler.engine.AttributeEngineProfiler;

public class TreeDomain {
    public static final String PATH_SEPARATOR = "/";
    public static final String ELEMENT_PREFIX = "[";
    public static final String ELEMENT_SUFFIX = "]";
    public static final String MISSING_REF_CODE = "!!";
    private final String profile;
    private Set<RegionCached> cachedRegions = new HashSet<RegionCached>();
    private List<HyperonDomainObjectImpl> rootElements = new ArrayList<HyperonDomainObjectImpl>();
    private Map<String, HyperonDomainObjectTypeImpl> typesByCodes = new HashMap<String, HyperonDomainObjectTypeImpl>();
    private List<HyperonDomainObjectType> rootTypes = new ArrayList<HyperonDomainObjectType>();
    private Map<String, String> pathById = new HashMap<String, String>();
    private Map<String, List<String>> childrenIds = new HashMap<String, List<String>>();
    private Map<String, Integer> newCopyFromId = new HashMap<String, Integer>();
    private Set<String> inconsistency = new HashSet<String>();
    private Set<String> duplicated = new HashSet<String>();

    public TreeDomain(String profile2) {
        this.profile = profile2;
    }

    public HyperonDomainObject getObjectsByPath(String path) {
        if (this.isRootPath(path)) {
            return this.getRoot();
        }
        return this.getRoot().getDomain(path);
    }

    public HyperonDomainObjectType getType(String typeCode, String collectionCode) {
        return this.typesByCodes.get(TreeDomain.fullTokenResolver(typeCode, collectionCode));
    }

    public static String fullTokenResolver(String typeCode, String elementCode) {
        return DomainTokenResolver.resolveFullToken(typeCode, elementCode);
    }

    public boolean isAnyRoot() {
        return !this.rootElements.isEmpty();
    }

    public void initObjectIdsAndPath(HyperonDomainObjectImpl domainObj) {
        if (domainObj.getParentId() == null) {
            return;
        }
        String parentId = domainObj.getParentId().toString();
        List<String> children = this.childrenIds.get(parentId);
        if (children == null) {
            children = new ArrayList<String>();
        }
        children.add(Objects.isNull(domainObj.getId()) ? "" : domainObj.getId().toString());
        this.childrenIds.put(parentId, children);
    }

    public void setRoots(List<HyperonDomainObjectImpl> roots, Map<String, HyperonDomainObjectTypeImpl> types, Map<String, List<ReferenceDto>> parentReference, Map<String, List<DomainCacheJdbcDao.DomainAttributeLoadWrapper>> objectIdToAllAttributes) {
        this.typesByCodes = this.getTypesByCode(types);
        this.rootElements = new ArrayList<HyperonDomainObjectImpl>(roots);
        this.pathById.clear();
        this.cachedRegions.clear();
        this.updateElements(roots, null, objectIdToAllAttributes);
        this.processReferences(roots, parentReference, new HashSet<Integer>());
        this.findRootType();
        this.clearTempElements();
    }

    public void addInconsistency(String value) {
        this.inconsistency.add(value);
    }

    public void addDuplicated(String value) {
        this.duplicated.add(value);
    }

    private void processReferences(Collection<HyperonDomainObjectImpl> parents, Map<String, List<ReferenceDto>> parentReference, Set<Integer> processed) {
        for (HyperonDomainObjectImpl object : parents) {
            String id = Integer.toString(object.getId());
            if (parentReference.containsKey(id)) {
                if (processed.contains(object.getId())) continue;
                processed.add(object.getId());
                List<ReferenceDto> paths = parentReference.get(id);
                for (ReferenceDto path : paths) {
                    HyperonDomainObjectImpl reference = this.processReference(object.getId(), path);
                    object.addReference(reference, path.getParentCollectionCode());
                }
            }
            this.processReferences(object.getChildren(), parentReference, processed);
        }
    }

    private HyperonDomainObjectImpl processReference(Integer parentId, ReferenceDto path) {
        HyperonDomainObject referenced = this.getObjectsByPath(path.getPath().substring(0, path.getPath().length() - 1));
        if (referenced == null) {
            referenced = this.createReference(parentId, path);
        }
        return (HyperonDomainObjectImpl)referenced;
    }

    private HyperonDomainObject createReference(Integer parentId, ReferenceDto path) {
        HyperonDomainObjectTypeImpl collection = new HyperonDomainObjectTypeImpl(path.getCollectionId(), path.getParentCollectionCode(), "");
        HyperonDomainObjectImpl referenced = new HyperonDomainObjectImpl(HyperonDomainObjectImpl.getTmpId(), MISSING_REF_CODE, path.getPath(), "", collection, parentId, true);
        referenced.setRegion(new RegionCached());
        return referenced;
    }

    private Map<String, HyperonDomainObjectTypeImpl> getTypesByCode(Map<String, HyperonDomainObjectTypeImpl> types) {
        HashMap<String, HyperonDomainObjectTypeImpl> result = new HashMap<String, HyperonDomainObjectTypeImpl>();
        for (Map.Entry<String, HyperonDomainObjectTypeImpl> type : types.entrySet()) {
            result.put(type.getValue().getFullCode(), type.getValue());
        }
        return result;
    }

    private void findRootType() {
        for (Map.Entry<String, HyperonDomainObjectTypeImpl> typeByCode : this.typesByCodes.entrySet()) {
            if (!typeByCode.getValue().isRootCollection()) continue;
            this.rootTypes.add(typeByCode.getValue());
        }
    }

    public List<String> getChildrenIds(String parentId) {
        if (this.childrenIds.get(parentId) != null) {
            return new ArrayList<String>((Collection)this.childrenIds.get(parentId));
        }
        return new ArrayList<String>();
    }

    private void updateElements(Collection<HyperonDomainObjectImpl> roots, HyperonDomainObjectImpl parent, Map<String, List<DomainCacheJdbcDao.DomainAttributeLoadWrapper>> objectIdToAllAttributes) {
        for (HyperonDomainObjectImpl obj : roots) {
            obj.setParent(parent);
            this.setFullPath(obj);
            this.updateAttributeProfilerLoadTime(objectIdToAllAttributes, obj);
            this.cachedRegions.add(obj.getRegion());
            this.updateElements(obj.getChildren(), obj, objectIdToAllAttributes);
        }
    }

    private void setFullPath(HyperonDomainObjectImpl domainObj) {
        Object path;
        if (domainObj.getParentId() == null) {
            path = PATH_SEPARATOR + domainObj.getFullElementCode();
        } else {
            StringBuilder parentPath = new StringBuilder(this.pathById.get(Integer.toString(domainObj.getParentId())));
            if (!StringUtils.endsWith(parentPath, PATH_SEPARATOR)) {
                parentPath.append(PATH_SEPARATOR);
            }
            path = parentPath.append(domainObj.getFullElementCode()).toString();
        }
        domainObj.setPath((String)path);
        this.pathById.put(Integer.toString(domainObj.getIdToSelectChildren()), (String)path);
        if (!domainObj.getIdToSelectChildren().equals(domainObj.getId())) {
            this.pathById.put(Integer.toString(domainObj.getId()), (String)path);
        }
    }

    private void updateAttributeProfilerLoadTime(Map<String, List<DomainCacheJdbcDao.DomainAttributeLoadWrapper>> objectIdToAllAttributes, HyperonDomainObjectImpl obj) {
        objectIdToAllAttributes.getOrDefault(Integer.toString(obj.getId()), Collections.emptyList()).forEach(wrapper -> AttributeEngineProfiler.DOMAIN.addLoadMeasure(new AttributeKey(obj.getPath(), wrapper.getDto().getCode()), wrapper.getLoadTime().getStart(), wrapper.getLoadTime().getEnd()));
    }

    private void clearTempElements() {
        this.childrenIds.clear();
        this.pathById.clear();
        this.newCopyFromId.clear();
    }

    public boolean isRootPath(String path) {
        return StringUtils.isBlank(path) || path.equals(PATH_SEPARATOR);
    }

    private HyperonDomainObject getRoot() {
        HyperonDomainObjectImpl rootObject = new HyperonDomainObjectImpl();
        rootObject.setChildren(this.rootElements);
        return rootObject;
    }

    public boolean isValid() {
        return this.inconsistency.isEmpty() && this.duplicated.isEmpty();
    }

    public void reloadRootElement(String childPath, HyperonDomainObjectImpl childNew) {
        String fullChildPath = childPath.endsWith(PATH_SEPARATOR) ? StringUtils.substringBeforeLast(childPath, PATH_SEPARATOR) : childPath;
        Iterator<HyperonDomainObjectImpl> it = this.rootElements.iterator();
        while (it.hasNext()) {
            HyperonDomainObjectImpl element = it.next();
            String elementPath = ((HyperonDomainObjectTypeImpl)element.getCollection()).isMultiple() ? element.getPath() : element.getFullPath();
            if (!fullChildPath.equals(elementPath) && !childPath.equals(elementPath)) continue;
            it.remove();
            break;
        }
        if (childNew != null) {
            this.rootElements.add(childNew);
        }
    }

    public boolean isChangeCopyFrom(Integer copyFrom) {
        return copyFrom != null && this.newCopyFromId.containsKey(Integer.toString(copyFrom));
    }

    public String getNewParentId(Integer copyFrom) {
        return Integer.toString(this.newCopyFromId.get(Integer.toString(copyFrom)));
    }

    public void addNewParents(Map<String, Integer> newParents) {
        this.newCopyFromId.putAll(newParents);
    }

    public String toString() {
        return "MpTreeDomain [cachedRegions=" + this.cachedRegions + ", rootElements=" + this.rootElements + ELEMENT_SUFFIX;
    }

    public String getProfile() {
        return this.profile;
    }

    public Set<RegionCached> getCachedRegions() {
        return this.cachedRegions;
    }

    public List<HyperonDomainObjectType> getRootTypes() {
        return this.rootTypes;
    }
}

