/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.rhino;

import java.util.List;
import org.smartparam.engine.annotated.annotations.FetchSuggestion;
import pl.decerto.hyperon.runtime.core.HyperonContext;
import pl.decerto.hyperon.runtime.core.HyperonEngine;
import pl.decerto.hyperon.runtime.exception.HyperonRuntimeException;
import pl.decerto.hyperon.runtime.model.HyperonDomainObject;
import pl.decerto.hyperon.runtime.rhino.domain.RhinoDomainElement;

public class RhinoDomain {
    private final HyperonEngine engine;

    public RhinoDomain(HyperonEngine engine) {
        this.engine = engine;
    }

    @FetchSuggestion(value="suggester.domain.get_profile_path_ctx")
    public RhinoDomainElement get(String profile2, String path, HyperonContext ctx) {
        HyperonDomainObject obj = this.engine.getDomain(profile2, path);
        if (obj == null) {
            throw new HyperonRuntimeException(String.format("Unknown path or profile: profile=[%s] path=[%s]", profile2, path));
        }
        return new RhinoDomainElement(obj, ctx);
    }

    @FetchSuggestion(value="suggester.domain.get_profile_path")
    public RhinoDomainElement get(String profile2, String path) {
        return this.get(profile2, path, null);
    }

    @FetchSuggestion(value="suggester.domain.get_profile_ctx")
    public RhinoDomainElement get(String profile2, HyperonContext ctx) {
        return this.get(profile2, null, ctx);
    }

    @FetchSuggestion(value="suggester.domain.get_profile")
    public RhinoDomainElement get(String profile2) {
        return this.get(profile2, null, null);
    }

    @FetchSuggestion(value="suggester.domain.getProfiles")
    public List<String> getProfiles() {
        return this.engine.getProfiles();
    }
}

